/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractTrailParticle;
import vzling.lib.init.ParticleInit;

@Environment(value=EnvType.CLIENT)
public class EntityTrailParticle
extends AbstractTrailParticle {
    private static final class_2960 TRAIL_TEXTURE = new class_2960("vzling", "textures/particle/entity_trail.png");
    private final int entityId;

    public EntityTrailParticle(class_638 world, double x, double y, double z, int r, int g, int b, int entityId) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.field_3847 = Integer.MAX_VALUE;
        this.field_3844 = 0.0f;
        this.field_3874 = x;
        this.field_3854 = y;
        this.field_3871 = z;
        this.entityId = entityId;
    }

    @Override
    public void method_3070() {
        float fade = 1.0f - (float)this.field_3866 / (float)this.field_3847;
        this.trailA = 0.8f * fade;
        class_1297 entity = this.field_3851.method_8469(this.entityId);
        if (entity != null) {
            class_243 vec = entity.method_19538().method_1020(new class_243(this.field_3874, this.field_3854, this.field_3871)).method_1031(0.0, 0.25, 0.0);
            this.field_3852 = vec.method_10216();
            this.field_3869 = vec.method_10214();
            this.field_3850 = vec.method_10215();
        } else {
            this.method_3085();
        }
        super.method_3070();
    }

    public int method_3068(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 1.0f;
    }

    @Override
    public class_2960 getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.field_3847 - this.field_3866);
    }

    public record ColorData(int r, int g, int b, int entityId) implements class_2394
    {
        public static final class_2394.class_2395<ColorData> DESERIALIZER = new class_2394.class_2395<ColorData>(){

            @NotNull
            public ColorData fromCommand(@NotNull class_2396<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                int entityId = reader.readInt();
                return new ColorData(r, g, b, entityId);
            }

            @NotNull
            public ColorData fromNetwork(@NotNull class_2396<ColorData> particleTypeIn, class_2540 buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b), (App)Codec.INT.fieldOf("entityId").forGetter(ColorData::entityId)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void method_10294(class_2540 buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeInt(this.entityId);
        }

        @NotNull
        public String method_10293() {
            return String.format(Locale.ROOT, "%s %d %d %d %d", class_7923.field_41180.method_10221(this.method_10295()), this.r, this.g, this.b, this.entityId);
        }

        @NotNull
        public class_2396<ColorData> method_10295() {
            return ParticleInit.ENTITY_TRAIL.get();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<ColorData> {
        public class_703 createParticle(ColorData data, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EntityTrailParticle(level, x, y, z, data.r(), data.g(), data.b(), data.entityId());
        }
    }
}

