/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractRotParticle;
import vzling.lib.init.ParticleInit;

@Environment(value=EnvType.CLIENT)
public class VerticalRippleParticle
extends AbstractRotParticle {
    protected VerticalRippleParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, float xRot, float yRot, float zRot, class_4002 spriteSet) {
        super(level, x, y, z, xd, yd, zd, xRot, yRot, zRot);
        this.field_17867 = 0.0f;
        this.field_3847 = 10;
        this.field_3852 = xd;
        this.field_3869 = yd;
        this.field_3850 = zd;
        this.method_18140(spriteSet);
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Override
    public void method_3074(@NotNull class_4588 consumer, @NotNull class_4184 camera, float partialTicks) {
        float progress = Math.max(0.0f, ((float)this.field_3866 + partialTicks) / (float)this.field_3847);
        this.field_17867 = progress * 1.25f;
        this.field_3841 = class_3532.method_15363((float)(1.0f - progress), (float)0.0f, (float)1.0f);
        super.method_3074(consumer, camera, partialTicks);
    }

    public record RotData(float xRot, float yRot, float zRot) implements class_2394
    {
        public static final class_2394.class_2395<RotData> DESERIALIZER = new class_2394.class_2395<RotData>(){

            @NotNull
            public RotData fromCommand(@NotNull class_2396<RotData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float xRot = reader.readFloat();
                reader.expect(' ');
                float yRot = reader.readFloat();
                reader.expect(' ');
                float zRot = reader.readFloat();
                return new RotData(xRot, yRot, zRot);
            }

            @NotNull
            public RotData fromNetwork(@NotNull class_2396<RotData> particleTypeIn, class_2540 buffer) {
                return new RotData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public static Codec<RotData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("xRot").forGetter(RotData::xRot), (App)Codec.FLOAT.fieldOf("yRot").forGetter(RotData::yRot), (App)Codec.FLOAT.fieldOf("zRot").forGetter(RotData::zRot)).apply((Applicative)codecBuilder, RotData::new));
        }

        public void method_10294(class_2540 buffer) {
            buffer.writeFloat(this.xRot);
            buffer.writeFloat(this.yRot);
            buffer.writeFloat(this.zRot);
        }

        @NotNull
        public String method_10293() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", class_7923.field_41180.method_10221(this.method_10295()), Float.valueOf(this.xRot), Float.valueOf(this.yRot), Float.valueOf(this.zRot));
        }

        @NotNull
        public class_2396<RotData> method_10295() {
            return ParticleInit.VERTICAL_RIPPLE.get();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record RotFactory(class_4002 spriteSet) implements class_707<RotData>
    {
        public class_703 createParticle(RotData data, @NotNull class_638 level, double x, double y, double z, double xs, double ys, double zs) {
            return new VerticalRippleParticle(level, x, y, z, xs, ys, zs, data.xRot(), data.yRot(), data.zRot(), this.spriteSet);
        }
    }
}

