/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.client.animation.ExampleMobEntityAnimation;
import vzling.lib.entity.BossEntity;
import vzling.lib.entity.IDialogEntity;
import vzling.lib.entity.ISkillEntity;
import vzling.lib.entity.ai.VzlingPathNavigateGround;
import vzling.lib.entity.dialog.AbstractDialog;
import vzling.lib.entity.dialog.DialogOption;
import vzling.lib.entity.dialog.OptionDialog;
import vzling.lib.entity.dialog.TextDialog;
import vzling.lib.entity.goal.EmptyMeleeAttackGoal;
import vzling.lib.entity.goal.LookAtDialogPlayerGoal;
import vzling.lib.entity.goal.LookAtTargetGoal;
import vzling.lib.entity.skill.SkillManager;
import vzling.lib.entity.skill.example_mob.FistSkill;
import vzling.lib.entity.skill.example_mob.KickSkill;
import vzling.lib.entity.skill.example_mob.SpellSkill;
import vzling.lib.platform.VzlingPlatform;
import vzling.lib.util.MiscUtil;

public class ExampleMobEntity
extends BossEntity
implements IDialogEntity {
    public final VzlingAnimation IDLE = new VzlingAnimation(this, new class_2960("vzling", "example_mob_idle"));
    public final VzlingAnimation ATTACK = new VzlingAnimation(this, new class_2960("vzling", "example_mob_attack"));
    public final VzlingAnimation KICK = new VzlingAnimation(this, new class_2960("vzling", "example_mob_kick"));
    public final VzlingAnimation SPELL = new VzlingAnimation(this, new class_2960("vzling", "example_mob_spell"));
    public final VzlingAnimation PHASE = new VzlingAnimation(this, new class_2960("vzling", "example_mob_phase"));
    public final VzlingAnimation SPAWN = new VzlingAnimation(this, new class_2960("vzling", "example_mob_spawn"));
    public final SkillManager<ExampleMobEntity> skillManager = new SkillManager<ExampleMobEntity>(this, List.of(new FistSkill(), new KickSkill(), new SpellSkill()));
    private final class_3213 bossEvent = new class_3213(this.method_5476(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795);
    private class_1657 dialogPlayer;

    public ExampleMobEntity(class_1299<? extends class_1588> type, class_1937 level) {
        super(type, level);
        if (VzlingPlatform.INSTANCE.isClientSide()) {
            this.IDLE.setDefinition(ExampleMobEntityAnimation.IDLE);
            this.ATTACK.setDefinition(ExampleMobEntityAnimation.ATTACK);
            this.KICK.setDefinition(ExampleMobEntityAnimation.KICK);
            this.SPELL.setDefinition(ExampleMobEntityAnimation.SPELL);
            this.PHASE.setDefinition(ExampleMobEntityAnimation.PHASE);
            this.SPAWN.setDefinition(ExampleMobEntityAnimation.SPAWN);
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23717, 1024.0);
    }

    @Override
    public void updatePhase() {
        if ((this.method_6032() <= this.method_6063() / 2.0f || this.updatePhase) && (this.getPhase() != 2 || this.updatePhase)) {
            if (!this.updatePhase) {
                this.playAnimation((class_1297)this, this.PHASE);
                this.phaseTick = 0;
                this.updatePhase = true;
            }
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
            this.setUsingSkill(false);
            this.setSkillTick(0);
            ++this.phaseTick;
            if (!this.method_37908().field_9236) {
                this.field_6008 = 20;
            }
            if (this.phaseTick == 1) {
                this.method_43077(class_3417.field_14688);
            }
            if (this.phaseTick == 24) {
                this.method_43077(class_3417.field_14931);
                this.setPhase(2);
                MiscUtil.startShake(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), 32.0, 6.0f, 20);
            }
            if (this.phaseTick >= 50) {
                this.updatePhase = false;
            }
        }
    }

    @Override
    public void spawn() {
        if (!this.isSpawned()) {
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
            this.setUsingSkill(false);
            this.setSkillTick(0);
            ++this.spawnTick;
            if (!this.method_37908().field_9236) {
                this.field_6008 = 20;
            }
            if (this.spawnTick >= 20) {
                this.setSpawned(true);
            }
        }
    }

    @Override
    public boolean hasSpawnProcess() {
        return true;
    }

    @Override
    public void selectSkillType() {
        double random = this.method_6051().method_43058();
        if (random <= 0.44) {
            this.setSkillType(0);
        } else if (random <= 0.88) {
            this.setSkillType(1);
        } else {
            this.setSkillType(2);
        }
    }

    @Override
    public SkillManager<? extends ISkillEntity> getSkillManager() {
        return this.skillManager;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, new LookAtDialogPlayerGoal<ExampleMobEntity>(this));
        this.field_6201.method_6277(1, (class_1352)new EmptyMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new LookAtTargetGoal((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42250) || source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42249)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.playAnimationIfStopped((class_1297)this, this.IDLE);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5674(class_2940<?> accessor) {
        if (accessor.equals((Object)USING_SKILL) && this.isUsingSkill()) {
            this.stopAllAnimStates();
            switch (this.getSkillType()) {
                case 0: {
                    this.playAnimation((class_1297)this, this.ATTACK);
                    break;
                }
                case 1: {
                    this.playAnimation((class_1297)this, this.KICK);
                    break;
                }
                case 2: {
                    this.playAnimation((class_1297)this, this.SPELL);
                }
            }
        }
        super.method_5674(accessor);
    }

    private void stopAllAnimStates() {
        this.stopAnimation((class_1297)this, this.ATTACK);
        this.stopAnimation((class_1297)this, this.KICK);
        this.stopAnimation((class_1297)this, this.SPELL);
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    @Override
    public int getDamageTime() {
        return 20;
    }

    @Override
    public float getDamageMap() {
        return 20.0f;
    }

    @NotNull
    protected class_1408 method_5965(class_1937 level) {
        return new VzlingPathNavigateGround((class_1314)this, level);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<AbstractDialog> getDialogList() {
        return List.of(new TextDialog(0, (class_2561)class_2561.method_43471((String)"entity.vzling.example_mob.dialog.0"), 0xFFFFFF, 2, false), new OptionDialog(1, (class_2561)class_2561.method_43471((String)"entity.vzling.example_mob.dialog.1"), 0xFFFFFF, 2, false).addOption(new DialogOption((class_2561)class_2561.method_43471((String)"item.minecraft.iron_ingot"), 0xFFFFFF, 2, false)).addOption(new DialogOption((class_2561)class_2561.method_43471((String)"item.minecraft.gold_ingot"), 0xFFFFFF, 2, false)).addOption(new DialogOption((class_2561)class_2561.method_43471((String)"item.minecraft.diamond"), 0xFFFFFF, 2, false)).addOption(new DialogOption((class_2561)class_2561.method_43471((String)"item.minecraft.netherite_ingot"), 0xFFFFFF, 2, false)), new TextDialog(2, (class_2561)class_2561.method_43471((String)"entity.vzling.example_mob.dialog.2"), 0xFFFFFF, 2, false));
    }

    @Override
    public void onKeyPressed(int keyCode, int currentIndex, int selectedOption, class_1657 player) {
        if (currentIndex == 1 && !this.method_37908().field_9236) {
            switch (selectedOption) {
                case 0: {
                    player.method_7270(class_1802.field_8620.method_7854());
                    break;
                }
                case 1: {
                    player.method_7270(class_1802.field_8695.method_7854());
                    break;
                }
                case 2: {
                    player.method_7270(class_1802.field_8477.method_7854());
                    break;
                }
                case 3: {
                    player.method_7270(class_1802.field_22020.method_7854());
                }
            }
        }
        if (currentIndex == 2) {
            this.setDialogPlayer(null);
        }
    }

    @Override
    public void setDialogPlayer(@Nullable class_1657 dialogPlayer) {
        this.dialogPlayer = dialogPlayer;
    }

    @Override
    public class_1657 getDialogPlayer() {
        return this.dialogPlayer;
    }
}

