/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.EntityTrailParticle;
import vzling.lib.init.ParticleInit;

public class RainbowParticle
extends EntityTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("vzling", "textures/particle/rainbow_trail.png");

    public RainbowParticle(ClientLevel world, double x, double y, double z, int r, int g, int b, int entityId) {
        super(world, x, y, z, r, g, b, entityId);
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    public record ColorData(int r, int g, int b, int entityId) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<ColorData> DESERIALIZER = new ParticleOptions.Deserializer<ColorData>(){

            @NotNull
            public ColorData fromCommand(@NotNull ParticleType<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                int entityId = reader.readInt();
                return new ColorData(r, g, b, entityId);
            }

            @NotNull
            public ColorData fromNetwork(@NotNull ParticleType<ColorData> particleTypeIn, FriendlyByteBuf buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b), (App)Codec.INT.fieldOf("entityId").forGetter(ColorData::entityId)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeInt(this.entityId);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b, this.entityId);
        }

        @NotNull
        public ParticleType<ColorData> m_6012_() {
            return ParticleInit.RAINBOW_TRAIL.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ColorData> {
        public Particle createParticle(ColorData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RainbowParticle(level, x, y, z, data.r(), data.g(), data.b(), data.entityId());
        }
    }
}

