/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import vzling.lib.client.renderer.VzlingRenderType;
import vzling.lib.entity.RayAttack;
import vzling.lib.entity.RayAttackUser;
import vzling.lib.util.MathUtil;

@OnlyIn(value=Dist.CLIENT)
public abstract class LaserBeamRenderer<T extends RayAttack>
extends EntityRenderer<T> {
    private boolean playerCast = false;

    public LaserBeamRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public float getTextureWidth() {
        return 128.0f;
    }

    public float getBeamRadius(T entity) {
        return 1.0f;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        RayAttackUser user;
        Entity entity2;
        double entityX = Mth.m_14139_((double)partialTicks, (double)((RayAttack)((Object)entity)).f_19854_, (double)entity.m_20185_());
        double entityY = Mth.m_14139_((double)partialTicks, (double)((RayAttack)((Object)entity)).f_19855_, (double)entity.m_20186_());
        double entityZ = Mth.m_14139_((double)partialTicks, (double)((RayAttack)((Object)entity)).f_19856_, (double)entity.m_20189_());
        stack.m_85836_();
        if (((RayAttack)((Object)entity)).getCaster().isPresent()) {
            Entity caster = ((RayAttack)((Object)entity)).getCaster().get();
            double posX = Mth.m_14139_((double)partialTicks, (double)caster.f_19854_, (double)caster.m_20185_());
            double posY = Mth.m_14139_((double)partialTicks, (double)caster.f_19855_, (double)caster.m_20186_());
            double posZ = Mth.m_14139_((double)partialTicks, (double)caster.f_19856_, (double)caster.m_20189_());
            Vec3 pos = ((RayAttack)((Object)entity)).getPositionForCaster(caster, new Vec3(posX, posY, posZ));
            posX = pos.f_82479_;
            posY = pos.f_82480_;
            posZ = pos.f_82481_;
            stack.m_85837_(posX - entityX, posY - entityY, posZ - entityZ);
        }
        boolean bl = this.playerCast = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && ((RayAttack)((Object)entity)).getCaster().isPresent() && Minecraft.m_91087_().f_91074_ != null && ((RayAttack)((Object)entity)).getCaster().get().m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_());
        if (this.playerCast && Minecraft.m_91087_().m_91288_() != null) {
            Vec3 offset = MathUtil.rotationToPosition(0.5f, -Minecraft.m_91087_().m_91288_().m_146909_() - 90.0f, Minecraft.m_91087_().m_91288_().m_6080_() + 90.0f);
            stack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        }
        float yaw = Mth.m_14179_((float)partialTicks, (float)((RayAttack)((Object)entity)).prevYaw, (float)((RayAttack)((Object)entity)).getYaw()) * ((float)Math.PI / 180);
        float pitch = Mth.m_14179_((float)partialTicks, (float)((RayAttack)((Object)entity)).prevPitch, (float)((RayAttack)((Object)entity)).getPitch()) * ((float)Math.PI / 180);
        if (((RayAttack)((Object)entity)).getCaster().isPresent() && ((entity2 = ((RayAttack)((Object)entity)).getCaster().get()) instanceof RayAttackUser && (user = (RayAttackUser)entity2).isRayFollowingHeadRotation() || !(((RayAttack)((Object)entity)).getCaster().get() instanceof RayAttackUser)) && (entity2 = ((RayAttack)((Object)entity)).getCaster().get()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            yaw = (living.m_5675_(partialTicks) + 90.0f) * ((float)Math.PI / 180);
            pitch = -living.m_5686_(partialTicks) * ((float)Math.PI / 180);
        }
        float length = ((RayAttack)((Object)entity)).getLength();
        VertexConsumer consumer = bufferSource.m_6299_(VzlingRenderType.getEntityGlowEffect(this.m_5478_((Entity)entity)));
        this.renderBeam(entity, length, yaw, pitch, (float)((RayAttack)((Object)entity)).f_19797_ + partialTicks, partialTicks, stack, consumer, light);
        stack.m_85849_();
    }

    public void renderBeamPart(T entity, float length, float tickCount, float partialTicks, PoseStack stack, VertexConsumer consumer, int light) {
        PoseStack.Pose pose = stack.m_85850_();
        float factor = (float)Math.sin(tickCount);
        float xOffset = tickCount * 0.025f % this.getTextureWidth();
        this.vertex(pose, consumer, -this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f, 0.0f, 0.0f, -xOffset, 0.0f, 1.0f, light);
        this.vertex(pose, consumer, -this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f, length, 0.0f, 1.0f - xOffset, 0.0f, 1.0f, light);
        this.vertex(pose, consumer, this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f, length, 0.0f, 1.0f - xOffset, 1.0f, 1.0f, light);
        this.vertex(pose, consumer, this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f, 0.0f, 0.0f, -xOffset, 1.0f, 1.0f, light);
    }

    public void renderBeam(T entity, float length, float yaw, float pitch, float tickCount, float partialTicks, PoseStack poseStack, VertexConsumer vertexConsumer, int light) {
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotationX(1.5707964f));
        poseStack.m_252781_(new Quaternionf().rotationZ(yaw - 1.5707964f));
        poseStack.m_252781_(new Quaternionf().rotationX(-pitch));
        poseStack.m_85836_();
        if (!this.playerCast) {
            poseStack.m_252781_(new Quaternionf().rotationY(tickCount * ((float)Math.PI / 180)));
        }
        this.renderBeamPart(entity, length, tickCount, partialTicks, poseStack, vertexConsumer, light);
        poseStack.m_85849_();
        if (!this.playerCast) {
            for (int i = 1; i < 2; ++i) {
                poseStack.m_85836_();
                poseStack.m_252781_(new Quaternionf().rotationY((float)(i * 45) * ((float)Math.PI / 180)));
                this.renderBeamPart(entity, length, tickCount, partialTicks, poseStack, vertexConsumer, light);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer consumer, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int light) {
        consumer.m_252986_(pose.m_252922_(), offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

