/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.screen;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vzling.lib.entity.IDialogEntity;
import vzling.lib.entity.dialog.AbstractDialog;
import vzling.lib.entity.dialog.OptionDialog;
import vzling.lib.util.MiscUtil;

@OnlyIn(value=Dist.CLIENT)
public class DialogScreen
extends Screen {
    private final IDialogEntity entity;
    private final Player player;
    private final List<AbstractDialog> dialogs;
    private int currentIndex = 0;
    private int tick = 0;
    private int selectedOption = 0;

    public DialogScreen(IDialogEntity entity, Player player, List<AbstractDialog> dialogs) {
        super((Component)Component.m_237113_((String)"Dialog"));
        this.entity = entity;
        this.player = player;
        this.dialogs = dialogs;
    }

    public void m_86600_() {
        if (this.currentIndex >= this.dialogs.size()) {
            this.m_7379_();
        }
        ++this.tick;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.f_96543_ / 2 + this.getXOffset();
        int y = this.f_96544_ + this.getYOffset();
        this.renderBg(guiGraphics);
        if (this.currentIndex < this.dialogs.size()) {
            IDialogEntity iDialogEntity = this.entity;
            if (iDialogEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)iDialogEntity;
                InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(x - 25), (int)(y + 65), (int)25, (float)(x - 25 - mouseX), (float)(y + 25 - mouseY), (LivingEntity)living);
            }
            this.dialogs.get(this.currentIndex).render(guiGraphics, x, y, this.tick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.currentIndex < this.dialogs.size()) {
            AbstractDialog dialog = this.dialogs.get(this.currentIndex);
            if (dialog instanceof OptionDialog) {
                OptionDialog optionDialog = (OptionDialog)dialog;
                int size = optionDialog.getOptions().size();
                if (keyCode == 265) {
                    this.selectedOption = Mth.m_14045_((int)(this.selectedOption - 1), (int)0, (int)(size - 1));
                    return true;
                }
                if (keyCode == 264) {
                    this.selectedOption = Mth.m_14045_((int)(this.selectedOption + 1), (int)0, (int)(size - 1));
                    return true;
                }
                if (keyCode == 257 || keyCode == 335) {
                    if (dialog.isFinished(this.tick)) {
                        this.entity.onKeyPressed(keyCode, this.currentIndex, this.selectedOption, this.player);
                        IDialogEntity iDialogEntity = this.entity;
                        if (iDialogEntity instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)iDialogEntity;
                            MiscUtil.sendDialogPacket(keyCode, living.m_19879_(), this.player.m_19879_(), this.currentIndex, this.selectedOption);
                        }
                        this.nextDialog();
                    } else {
                        this.tick = dialog.getComponent().getString().length() * dialog.getTypeSpeed();
                    }
                    return true;
                }
            } else if (keyCode == 257 || keyCode == 335) {
                if (dialog.isFinished(this.tick)) {
                    this.entity.onKeyPressed(keyCode, this.currentIndex, -1, this.player);
                    IDialogEntity iDialogEntity = this.entity;
                    if (iDialogEntity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)iDialogEntity;
                        MiscUtil.sendDialogPacket(keyCode, living.m_19879_(), this.player.m_19879_(), this.currentIndex, -1);
                    }
                    this.nextDialog();
                } else {
                    this.tick = dialog.getComponent().getString().length() * dialog.getTypeSpeed();
                }
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void addIndex(int index) {
        this.currentIndex += index;
        this.tick = 0;
        if (this.currentIndex >= this.dialogs.size()) {
            this.m_7379_();
        }
    }

    public void nextDialog() {
        this.addIndex(1);
    }

    public void previousDialog() {
        this.addIndex(-1);
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public void renderBg(GuiGraphics guiGraphics) {
        guiGraphics.m_280163_(new ResourceLocation("vzling", "textures/dialog/dialog.png"), this.f_96543_ / 2 - 145, this.f_96544_ - 100, 0.0f, 0.0f, 289, 76, 289, 76);
    }

    public int getXOffset() {
        return -85;
    }

    public int getYOffset() {
        return -100;
    }

    public boolean m_7043_() {
        return false;
    }
}

