/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.lib.entity.AbstractSkillEntity;

public abstract class BossEntity
extends AbstractSkillEntity {
    public static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SPAWNED = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int phaseTick = 0;
    public boolean updatePhase = false;
    public int spawnTick = 0;
    private int reducedDamageTicks;

    public BossEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(SPAWNED, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Phase", this.getPhase());
        tag.m_128379_("Spawned", this.isSpawned());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Phase")) {
            this.setPhase(tag.m_128451_("Phase"));
        }
        if (tag.m_128441_("Spawned")) {
            this.setSpawned(tag.m_128471_("Spawned"));
        }
    }

    public boolean m_147207_(MobEffectInstance instance, @Nullable Entity entity) {
        return instance.m_19544_().m_19486_() && super.m_147207_(instance, entity);
    }

    public void m_147215_(MobEffectInstance instance, @Nullable Entity entity) {
        if (instance.m_19544_().m_19486_()) {
            super.m_147215_(instance, entity);
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        return groupData;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public void m_147240_(double scale, double x, double y) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.reducedDamageTicks > 0) {
            --this.reducedDamageTicks;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21525_() && this.m_6084_()) {
            this.updatePhase();
            if (this.hasSpawnProcess()) {
                this.spawn();
            } else if (!this.isSpawned()) {
                this.setSpawned(true);
            }
        }
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public abstract void updatePhase();

    public abstract void spawn();

    public abstract boolean hasSpawnProcess();

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public boolean isSpawned() {
        return (Boolean)this.f_19804_.m_135370_(SPAWNED);
    }

    public void setSpawned(boolean spawned) {
        this.f_19804_.m_135381_(SPAWNED, (Object)spawned);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (!this.isSpawned() || this.updatePhase) {
            return false;
        }
        if (this.getDamageTime() > 0 && this.reducedDamageTicks > 0) {
            amount *= 1.0f - (float)this.reducedDamageTicks / (float)this.getDamageTime();
        }
        boolean flag = super.m_6469_(source, Math.min(amount, this.getDamageMap()));
        if (this.getDamageTime() > 0 && flag) {
            this.reducedDamageTicks = this.getDamageTime();
        }
        return flag;
    }

    public int getDamageTime() {
        return 0;
    }

    public float getDamageMap() {
        return Float.MAX_VALUE;
    }
}

