/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import vzling.lib.init.EntityInit;
import vzling.lib.util.EntityUtil;

public class BulletEntity
extends ThrowableProjectile {
    private final Vec3[] trailPositions = new Vec3[16];
    private int trailPointer = -1;
    public int trailR = 0;
    public int trailG = 0;
    public int trailB = 0;
    private float baseDamage;

    public BulletEntity(EntityType<? extends ThrowableProjectile> type, Level level) {
        super(type, level);
        this.setBaseDamage(1.0f);
    }

    public BulletEntity(Level level, LivingEntity shooter, float baseDamage) {
        super(EntityInit.BULLET.get(), shooter, level);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.25, shooter.m_20189_());
        this.setBaseDamage(baseDamage);
    }

    public BulletEntity(Level level, LivingEntity shooter, float baseDamage, int trailR, int trailG, int trailB) {
        this(level, shooter, baseDamage);
        this.trailR = trailR;
        this.trailG = trailG;
        this.trailB = trailB;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 200) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_) {
            Vec3 trailAt = this.m_20182_();
            if (this.trailPointer == -1) {
                Arrays.fill(this.trailPositions, trailAt);
            }
            if (++this.trailPointer == this.trailPositions.length) {
                this.trailPointer = 0;
            }
            this.trailPositions[this.trailPointer] = trailAt;
        }
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0xF;
        int j = this.trailPointer - pointer - 1 & 0xF;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    public void m_6001_(double xd, double yd, double zd) {
    }

    protected void m_8097_() {
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6783_(double distance) {
        double range = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(range)) {
            range = 10.0;
        }
        return distance < (range *= 64.0) * range;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        Entity entity = hitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2;
            Entity entity3;
            LivingEntity target = (LivingEntity)entity;
            target.f_19802_ = 0;
            if (EntityUtil.forceHurt(target, this.m_269291_().m_269299_((Entity)this, (entity3 = this.m_19749_()) instanceof LivingEntity ? (entity2 = (LivingEntity)entity3) : null), this.getBaseDamage())) {
                target.m_20256_(Vec3.f_82478_);
                target.f_19864_ = true;
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", this.baseDamage);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("damage", 99)) {
            this.baseDamage = tag.m_128457_("damage");
        }
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }
}

