/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.client.animation.ExampleMobEntityAnimation;
import vzling.lib.entity.BossEntity;
import vzling.lib.entity.IDialogEntity;
import vzling.lib.entity.ISkillEntity;
import vzling.lib.entity.ai.VzlingPathNavigateGround;
import vzling.lib.entity.dialog.AbstractDialog;
import vzling.lib.entity.dialog.DialogOption;
import vzling.lib.entity.dialog.OptionDialog;
import vzling.lib.entity.dialog.TextDialog;
import vzling.lib.entity.goal.EmptyMeleeAttackGoal;
import vzling.lib.entity.goal.LookAtDialogPlayerGoal;
import vzling.lib.entity.goal.LookAtTargetGoal;
import vzling.lib.entity.skill.SkillManager;
import vzling.lib.entity.skill.example_mob.FistSkill;
import vzling.lib.entity.skill.example_mob.KickSkill;
import vzling.lib.entity.skill.example_mob.SpellSkill;
import vzling.lib.platform.VzlingPlatform;
import vzling.lib.util.MiscUtil;

public class ExampleMobEntity
extends BossEntity
implements IDialogEntity {
    public final VzlingAnimation IDLE = new VzlingAnimation(this, new ResourceLocation("vzling", "example_mob_idle"));
    public final VzlingAnimation ATTACK = new VzlingAnimation(this, new ResourceLocation("vzling", "example_mob_attack"));
    public final VzlingAnimation KICK = new VzlingAnimation(this, new ResourceLocation("vzling", "example_mob_kick"));
    public final VzlingAnimation SPELL = new VzlingAnimation(this, new ResourceLocation("vzling", "example_mob_spell"));
    public final VzlingAnimation PHASE = new VzlingAnimation(this, new ResourceLocation("vzling", "example_mob_phase"));
    public final VzlingAnimation SPAWN = new VzlingAnimation(this, new ResourceLocation("vzling", "example_mob_spawn"));
    public final SkillManager<ExampleMobEntity> skillManager = new SkillManager<ExampleMobEntity>(this, List.of(new FistSkill(), new KickSkill(), new SpellSkill()));
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);
    private Player dialogPlayer;

    public ExampleMobEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        if (VzlingPlatform.INSTANCE.isClientSide()) {
            this.IDLE.setDefinition(ExampleMobEntityAnimation.IDLE);
            this.ATTACK.setDefinition(ExampleMobEntityAnimation.ATTACK);
            this.KICK.setDefinition(ExampleMobEntityAnimation.KICK);
            this.SPELL.setDefinition(ExampleMobEntityAnimation.SPELL);
            this.PHASE.setDefinition(ExampleMobEntityAnimation.PHASE);
            this.SPAWN.setDefinition(ExampleMobEntityAnimation.SPAWN);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 1024.0);
    }

    @Override
    public void updatePhase() {
        if ((this.m_21223_() <= this.m_21233_() / 2.0f || this.updatePhase) && (this.getPhase() != 2 || this.updatePhase)) {
            if (!this.updatePhase) {
                this.playAnimation((LivingEntity)this, this.PHASE);
                this.phaseTick = 0;
                this.updatePhase = true;
            }
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.setUsingSkill(false);
            this.setSkillTick(0);
            ++this.phaseTick;
            if (!this.m_9236_().f_46443_) {
                this.f_19802_ = 20;
            }
            if (this.phaseTick == 1) {
                this.m_216990_(SoundEvents.f_12557_);
            }
            if (this.phaseTick == 24) {
                this.m_216990_(SoundEvents.f_12513_);
                this.setPhase(2);
                MiscUtil.startShake(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 32.0, 6.0f, 20);
            }
            if (this.phaseTick >= 50) {
                this.updatePhase = false;
            }
        }
    }

    @Override
    public void spawn() {
        if (!this.isSpawned()) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.setUsingSkill(false);
            this.setSkillTick(0);
            ++this.spawnTick;
            if (!this.m_9236_().f_46443_) {
                this.f_19802_ = 20;
            }
            if (this.spawnTick >= 20) {
                this.setSpawned(true);
            }
        }
    }

    @Override
    public boolean hasSpawnProcess() {
        return true;
    }

    @Override
    public void selectSkillType() {
        double random = this.m_217043_().m_188500_();
        if (random <= 0.44) {
            this.setSkillType(0);
        } else if (random <= 0.88) {
            this.setSkillType(1);
        } else {
            this.setSkillType(2);
        }
    }

    @Override
    public SkillManager<? extends ISkillEntity> getSkillManager() {
        return this.skillManager;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, new LookAtDialogPlayerGoal<ExampleMobEntity>(this));
        this.f_21345_.m_25352_(1, (Goal)new EmptyMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268549_) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268415_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.playAnimationIfStopped((LivingEntity)this, this.IDLE);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)USING_SKILL) && this.isUsingSkill()) {
            this.stopAllAnimStates();
            switch (this.getSkillType()) {
                case 0: {
                    this.playAnimation((LivingEntity)this, this.ATTACK);
                    break;
                }
                case 1: {
                    this.playAnimation((LivingEntity)this, this.KICK);
                    break;
                }
                case 2: {
                    this.playAnimation((LivingEntity)this, this.SPELL);
                }
            }
        }
        super.m_7350_(accessor);
    }

    private void stopAllAnimStates() {
        this.stopAnimation((LivingEntity)this, this.ATTACK);
        this.stopAnimation((LivingEntity)this, this.KICK);
        this.stopAnimation((LivingEntity)this, this.SPELL);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    @Override
    public int getDamageTime() {
        return 20;
    }

    @Override
    public float getDamageMap() {
        return 20.0f;
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new VzlingPathNavigateGround((PathfinderMob)this, level);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<AbstractDialog> getDialogList() {
        return List.of(new TextDialog(0, (Component)Component.m_237115_((String)"entity.vzling.example_mob.dialog.0"), 0xFFFFFF, 2, false), new OptionDialog(1, (Component)Component.m_237115_((String)"entity.vzling.example_mob.dialog.1"), 0xFFFFFF, 2, false).addOption(new DialogOption((Component)Component.m_237115_((String)"item.minecraft.iron_ingot"), 0xFFFFFF, 2, false)).addOption(new DialogOption((Component)Component.m_237115_((String)"item.minecraft.gold_ingot"), 0xFFFFFF, 2, false)).addOption(new DialogOption((Component)Component.m_237115_((String)"item.minecraft.diamond"), 0xFFFFFF, 2, false)).addOption(new DialogOption((Component)Component.m_237115_((String)"item.minecraft.netherite_ingot"), 0xFFFFFF, 2, false)), new TextDialog(2, (Component)Component.m_237115_((String)"entity.vzling.example_mob.dialog.2"), 0xFFFFFF, 2, false));
    }

    @Override
    public void onKeyPressed(int keyCode, int currentIndex, int selectedOption, Player player) {
        if (currentIndex == 1 && !this.m_9236_().f_46443_) {
            switch (selectedOption) {
                case 0: {
                    player.m_36356_(Items.f_42416_.m_7968_());
                    break;
                }
                case 1: {
                    player.m_36356_(Items.f_42417_.m_7968_());
                    break;
                }
                case 2: {
                    player.m_36356_(Items.f_42415_.m_7968_());
                    break;
                }
                case 3: {
                    player.m_36356_(Items.f_42418_.m_7968_());
                }
            }
        }
        if (currentIndex == 2) {
            this.setDialogPlayer(null);
        }
    }

    @Override
    public void setDialogPlayer(@Nullable Player dialogPlayer) {
        this.dialogPlayer = dialogPlayer;
    }

    @Override
    public Player getDialogPlayer() {
        return this.dialogPlayer;
    }
}

