/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity.skill;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import vzling.lib.entity.ISkillEntity;

public abstract class BaseSkill<T extends Monster> {
    private final int id;
    private final int duration;
    private final int range;

    public BaseSkill(int id, int duration, int range) {
        this.id = id;
        this.duration = duration;
        this.range = range;
    }

    public int getId() {
        return this.id;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getRange() {
        return this.range;
    }

    public abstract void tick(T var1);

    public abstract void effect(T var1);

    public void start(T entity) {
        ((ISkillEntity)entity).setUsingSkill(true);
        ((ISkillEntity)entity).setSkillType(this.getId());
        ((ISkillEntity)entity).setSkillTick(0);
    }

    public void stop(T entity) {
        ((ISkillEntity)entity).setUsingSkill(false);
        ((ISkillEntity)entity).selectSkillType();
        ((ISkillEntity)entity).setSkillTick(0);
        this.resetSkillDelay(entity);
    }

    public void resetSkillDelay(T entity) {
        ((ISkillEntity)entity).getSkillManager().resetSkillDelay(5);
    }

    public boolean canUseSkill(T entity) {
        LivingEntity living = entity.m_5448_();
        if (living == null) {
            return false;
        }
        return entity.m_20280_((Entity)living) <= (double)this.getRange();
    }
}

