/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.forge.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import vzling.lib.entity.IDialogEntity;

public record DialogPacket(int keyCode, int entityId, int playerId, int currentIndex, int selectedOption) {
    public static void encode(DialogPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.keyCode);
        buf.writeInt(packet.entityId);
        buf.writeInt(packet.playerId);
        buf.writeInt(packet.currentIndex);
        buf.writeInt(packet.selectedOption);
    }

    public static DialogPacket decode(FriendlyByteBuf buf) {
        return new DialogPacket(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(DialogPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                Entity entity = player.m_9236_().m_6815_(packet.entityId);
                Entity entity1 = player.m_9236_().m_6815_(packet.playerId);
                if (entity instanceof IDialogEntity) {
                    IDialogEntity dialogEntity = (IDialogEntity)entity;
                    if (entity1 instanceof Player) {
                        Player player1 = (Player)entity1;
                        dialogEntity.onKeyPressed(packet.keyCode, packet.currentIndex, packet.selectedOption, player1);
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

