/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.forge.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import vzling.lib.entity.IDialogEntity;

public record OpenDialogPacket(int entityId) {
    public static void encode(OpenDialogPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId);
    }

    public static OpenDialogPacket decode(FriendlyByteBuf buf) {
        return new OpenDialogPacket(buf.readInt());
    }

    public static void handle(OpenDialogPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientHandler.handle(packet));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        static void handle(OpenDialogPacket packet) {
            Entity entity;
            if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId())) instanceof IDialogEntity) {
                IDialogEntity dialogEntity = (IDialogEntity)entity;
                Minecraft.m_91087_().m_91152_((Screen)dialogEntity.getDialogScreen(dialogEntity, (Player)Minecraft.m_91087_().f_91074_, dialogEntity.getDialogList()));
            }
        }
    }
}

