/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.forge.platform;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import vzling.lib.forge.VzlingModForge;
import vzling.lib.forge.network.DialogPacket;
import vzling.lib.forge.network.GunPacket;
import vzling.lib.forge.network.OpenDialogPacket;
import vzling.lib.forge.network.ScreenShakePacket;
import vzling.lib.forge.network.SendAnimationPacket;
import vzling.lib.forge.network.VzlingNetwork;
import vzling.lib.platform.RegistrySupplier;
import vzling.lib.platform.VzlingPlatform;

public class ForgePlatform
implements VzlingPlatform {
    @Override
    public boolean isClientSide() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public <T> vzling.lib.platform.DeferredRegister<T> deferredRegister(String namespace, ResourceKey<? extends Registry<T>> key) {
        return new ForgeDeferredRegister(namespace, key);
    }

    @Override
    public SpawnEggItem spawnEggItem(Supplier<EntityType<? extends Mob>> supplier, int backgroundColor, int highlightColor, Item.Properties properties) {
        return new ForgeSpawnEggItem(supplier, backgroundColor, highlightColor, properties);
    }

    @Override
    public void startShake(Level level, double x, double y, double z, double range, float magnitude, int duration) {
        if (!level.f_46443_) {
            VzlingNetwork.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, range, level.m_46472_())), (Object)new ScreenShakePacket(magnitude, duration));
        }
    }

    @Override
    public void sendAnimationPacket(Level level, int type, int entityId, ResourceLocation animationId) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                Entity entity = serverLevel.m_6815_(entityId);
                if (entity == null) continue;
                VzlingNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendAnimationPacket(type, entityId, animationId));
            }
        }
    }

    @Override
    public void gunPacket(int type) {
        VzlingNetwork.CHANNEL.sendToServer((Object)new GunPacket(type));
    }

    @Override
    public void sendDialogPacket(int keyCode, int entityId, int playerId, int currentIndex, int selectedOption) {
        VzlingNetwork.CHANNEL.sendToServer((Object)new DialogPacket(keyCode, entityId, playerId, currentIndex, selectedOption));
    }

    @Override
    public void sendOpenDialogPacket(int entityId, ServerPlayer player) {
        VzlingNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenDialogPacket(entityId));
    }

    static class ForgeDeferredRegister<T>
    implements vzling.lib.platform.DeferredRegister<T> {
        private final DeferredRegister<T> deferredRegister;
        private final String namespace;
        private final ResourceKey<? extends Registry<T>> key;

        ForgeDeferredRegister(String namespace, ResourceKey<? extends Registry<T>> key) {
            this.deferredRegister = DeferredRegister.create((ResourceLocation)key.m_135782_(), (String)namespace);
            this.namespace = namespace;
            this.key = key;
        }

        @Override
        public <I extends T> RegistrySupplier<I> register(String id, Supplier<? extends I> supplier) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id);
            final ResourceKey resourceKey = ResourceKey.m_135785_(this.key, (ResourceLocation)location);
            final RegistryObject object = this.deferredRegister.register(id, supplier);
            return new RegistrySupplier<I>(){

                @Override
                public Holder<I> asHolder() {
                    return (Holder)object.getHolder().get();
                }

                @Override
                public ResourceKey<I> getResourceKey() {
                    return resourceKey;
                }

                @Override
                public I get() {
                    return object.get();
                }
            };
        }

        @Override
        public void register() {
            this.deferredRegister.register(VzlingModForge.CONTEXT.getModEventBus());
        }
    }
}

