/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.entity.BulletEntity;
import vzling.lib.init.AttributeInit;
import vzling.lib.init.ItemInit;
import vzling.lib.item.AbstractSkillItem;
import vzling.lib.item.skill.SkillManager;
import vzling.lib.item.skill.gun.EjectSkill;

public abstract class GunItem
extends AbstractSkillItem {
    protected static final UUID BASE_BULLET_DAMAGE_UUID = UUID.fromString("68953A94-9643-4C7D-B719-07D4836F1ADE");
    protected static final UUID BASE_AIM_SPEED_UUID = UUID.fromString("8E0AE044-DCFA-4988-9050-3F4DEDF69E9E");
    protected static final UUID BASE_MAG_SIZE_UUID = UUID.fromString("B7258774-2672-4047-92C9-D8D485945F12");
    private final float bulletDamage;
    private final float aimSpeed;
    private final int magSize;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public final SkillManager<GunItem> skillManager = new SkillManager<GunItem>(this, List.of(new EjectSkill(this.getEjectDuration())));

    public GunItem(Item.Properties properties, float bulletDamage, float aimSpeed, int magSize) {
        super(properties);
        this.bulletDamage = Mth.m_14036_((float)bulletDamage, (float)0.0f, (float)Float.MAX_VALUE);
        this.aimSpeed = Mth.m_14036_((float)aimSpeed, (float)0.01f, (float)10.0f);
        this.magSize = Mth.m_14045_((int)magSize, (int)1, (int)Integer.MAX_VALUE);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)AttributeInit.BULLET_DAMAGE.get(), (Object)new AttributeModifier(BASE_BULLET_DAMAGE_UUID, "Weapon modifier", (double)this.bulletDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)AttributeInit.AIM_SPEED.get(), (Object)new AttributeModifier(BASE_AIM_SPEED_UUID, "Weapon modifier", (double)this.aimSpeed, AttributeModifier.Operation.MULTIPLY_BASE));
        builder.put((Object)AttributeInit.MAG_SIZE.get(), (Object)new AttributeModifier(BASE_MAG_SIZE_UUID, "Weapon modifier", (double)this.magSize, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public float getBulletDamage() {
        return this.bulletDamage;
    }

    public float getAimSpeed() {
        return this.aimSpeed;
    }

    public int getMagSize() {
        return this.magSize;
    }

    public abstract VzlingAnimation getShootAnimation();

    public abstract VzlingAnimation getEjectAnimation();

    public boolean shouldShootBullet(ItemStack stack) {
        return this.getBulletCount(stack) > 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_21206_() == stack) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public boolean m_6777_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        return false;
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int time, boolean selected) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, time, selected);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_() != stack) {
            stack.m_41784_().m_128350_("aimingProgress", 0.0f);
            stack.m_41784_().m_128379_("ejecting", false);
            stack.m_41784_().m_128405_("ejectTick", 0);
            this.stopAnimation(living, this.getEjectAnimation());
            this.stopAnimation(living, this.getShootAnimation());
        }
        if (stack.m_41783_() == null || stack.m_41783_().m_128456_()) {
            stack.m_41784_().m_128405_("bulletCount", 20);
        }
        if (stack.m_41784_().m_128471_("ejecting")) {
            stack.m_41784_().m_128405_("ejectTick", stack.m_41784_().m_128451_("ejectTick") + 1);
            if (stack.m_41784_().m_128451_("ejectTick") == this.getEjectTick() && entity instanceof Player) {
                Player player = (Player)entity;
                this.eject(player, stack);
            }
            if (stack.m_41784_().m_128451_("ejectTick") >= this.getEjectDuration()) {
                stack.m_41784_().m_128379_("ejecting", false);
                stack.m_41784_().m_128405_("ejectTick", 0);
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
        }
    }

    public int getBulletCount(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128451_("bulletCount");
        }
        return 0;
    }

    public void shootBullet(Player player, ItemStack stack) {
        BulletEntity bullet = this.getBullet(player.m_9236_(), (LivingEntity)player);
        bullet.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 8.0f, 0.0f);
        player.m_9236_().m_7967_((Entity)bullet);
        if (stack.m_41783_() != null) {
            stack.m_41783_().m_128405_("bulletCount", this.getBulletCount(stack) - 1);
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public BulletEntity getBullet(Level level, LivingEntity shooter) {
        return new BulletEntity(level, shooter, this.getBulletDamage(), 255, 255, 255);
    }

    public void eject(Player player, ItemStack stack) {
        int currentAmmo = this.getBulletCount(stack);
        int space = this.getMagSize() - currentAmmo;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slot = player.m_150109_().m_8020_(i);
            if (slot.m_41720_() != ItemInit.BULLET.get()) continue;
            int ammoToLoad = Math.min(space, slot.m_41613_());
            if (stack.m_41783_() != null) {
                stack.m_41783_().m_128405_("bulletCount", currentAmmo + ammoToLoad);
            }
            currentAmmo += ammoToLoad;
            slot.m_41774_(ammoToLoad);
            if ((space -= ammoToLoad) <= 0) break;
        }
    }

    public SkillManager<GunItem> getSkillManager() {
        return this.skillManager;
    }

    public abstract int getEjectDuration();

    public abstract int getEjectTick();
}

