/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vzling.lib.client.model.AnimatableItemModel;
import vzling.lib.client.model.ItemModel;
import vzling.lib.init.ItemInit;
import vzling.lib.item.GunItem;
import vzling.lib.item.IAnimatedItem;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    @Final
    private Minecraft f_265848_;

    @Shadow
    public abstract ItemModelShaper m_115103_();

    @Shadow
    public abstract BakedModel m_174264_(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3, int var4);

    @Shadow
    public abstract void m_115143_(ItemStack var1, ItemDisplayContext var2, boolean var3, PoseStack var4, MultiBufferSource var5, int var6, int var7, BakedModel var8);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void render(ItemStack stack, ItemDisplayContext context, boolean isLeftHand, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, BakedModel bakedModel, CallbackInfo ci) {
        IAnimatedItem item;
        LocalPlayer player = this.f_265848_.f_91074_;
        Item item2 = stack.m_41720_();
        if (item2 instanceof IAnimatedItem && (item = (IAnimatedItem)item2).getModel() != null && player != null) {
            if (!(item instanceof GunItem) || !isLeftHand) {
                float aimingProgress = stack.m_41784_().m_128457_("aimingProgress");
                if (item instanceof GunItem) {
                    GunItem gunItem = (GunItem)item;
                    aimingProgress = player.m_6117_() ? (aimingProgress += gunItem.getAimSpeed() / 10.0f) : (aimingProgress -= 0.1f);
                    aimingProgress = Mth.m_14036_((float)aimingProgress, (float)0.0f, (float)1.0f);
                    stack.m_41784_().m_128350_("aimingProgress", aimingProgress);
                }
                ItemModel<? extends IAnimatedItem> itemModel = item.getModel();
                poseStack.m_85836_();
                if (itemModel.getTransforms().m_269504_(context)) {
                    ItemTransform transform = itemModel.getTransforms().m_269404_(context);
                    poseStack.m_252880_(transform.f_111756_.x(), transform.f_111756_.y(), transform.f_111756_.z());
                    poseStack.m_252781_(new Quaternionf().rotationXYZ(transform.f_111755_.x(), transform.f_111755_.y(), transform.f_111755_.z()));
                    poseStack.m_85841_(transform.f_111757_.x(), transform.f_111757_.y(), transform.f_111757_.z());
                }
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_85837_(0.05, -1.0, 0.0);
                if (item instanceof GunItem && context.m_269069_()) {
                    poseStack.m_85837_(0.27 * (double)stack.m_41784_().m_128457_("aimingProgress"), 0.003125 * (double)stack.m_41784_().m_128457_("aimingProgress"), 0.5 * (double)stack.m_41784_().m_128457_("aimingProgress"));
                }
                if (this.f_265848_.f_91073_ != null && context.m_269069_()) {
                    if (itemModel instanceof AnimatableItemModel) {
                        AnimatableItemModel animatableItemModel = (AnimatableItemModel)itemModel;
                        animatableItemModel.setupAnim(stack.m_41720_(), (float)player.f_19797_ + (this.f_265848_.m_91104_() ? 0.0f : this.f_265848_.m_91296_()));
                    }
                    itemModel.renderHands(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)player.m_108560_())), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                itemModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)itemModel.getTextureLocation(stack.m_41720_()))), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderStatic(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/Level;III)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderStatic(LivingEntity entity, ItemStack stack, ItemDisplayContext displayContext, boolean isLeftHand, PoseStack poseStack, MultiBufferSource bufferSource, Level level, int light, int overlay, int seed, CallbackInfo ci) {
        if (!stack.m_41619_() && stack.m_150930_(ItemInit.LASER_STAFF.get())) {
            BakedModel bakedModel = this.m_174264_(stack, level, entity, seed);
            this.m_115143_(stack, displayContext, isLeftHand, poseStack, bufferSource, 255, overlay, bakedModel);
            ci.cancel();
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="LOAD", ordinal=0), ordinal=0, argsOnly=true)
    public BakedModel render(BakedModel bakedModel, ItemStack stack, ItemDisplayContext displayContext) {
        if (stack.m_150930_(ItemInit.LASER_STAFF.get()) && (displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED)) {
            return this.m_115103_().m_109393_().m_119422_(new ModelResourceLocation(new ResourceLocation("vzling", "laser_staff_inventory"), "inventory"));
        }
        return bakedModel;
    }
}

