/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.model;

import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.AnimationState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import vzling.lib.client.animation.KeyframeAnimations;

@OnlyIn(value=Dist.CLIENT)
public interface AnimatedModel {
    public static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    default public void animate(AnimationState state, AnimationDefinition definition, float tickCount) {
        this.animate(state, definition, tickCount, 1.0f, 1.0f);
    }

    default public void animate(AnimationState state, AnimationDefinition definition, float tickCount, float speed, float scale) {
        state.m_216974_(tickCount, speed);
        state.m_216979_(animState -> KeyframeAnimations.animate(this, definition, animState.m_216981_(), scale, ANIMATION_VECTOR_CACHE));
    }

    default public void animateWalk(AnimationDefinition definition, float swing, float swingAmount, float speed, float scale) {
        long accumulatedTime = (long)(swing * 50.0f * speed);
        float interpolationScale = Math.min(swingAmount * scale, 1.0f);
        KeyframeAnimations.animate(this, definition, accumulatedTime, interpolationScale, ANIMATION_VECTOR_CACHE);
    }

    public ModelPart root();

    default public Optional<ModelPart> getAnyDescendantWithName(String name) {
        return name.equals("root") ? Optional.of(this.root()) : this.root().m_171331_().filter(part -> part.m_233562_(name)).findFirst().map(part -> part.m_171324_(name));
    }
}

