/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.LargeVerticalRippleParticle;
import vzling.lib.init.ParticleInit;

@OnlyIn(value=Dist.CLIENT)
public class DuckLargeVerticalRippleParticle
extends LargeVerticalRippleParticle {
    protected DuckLargeVerticalRippleParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, float xRot, float yRot, float zRot, SpriteSet spriteSet) {
        super(level, x, y, z, xd, yd, zd, xRot, yRot, zRot, spriteSet);
    }

    public record RotData(float xRot, float yRot, float zRot) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<RotData> DESERIALIZER = new ParticleOptions.Deserializer<RotData>(){

            @NotNull
            public RotData fromCommand(@NotNull ParticleType<RotData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float xRot = reader.readFloat();
                reader.expect(' ');
                float yRot = reader.readFloat();
                reader.expect(' ');
                float zRot = reader.readFloat();
                return new RotData(xRot, yRot, zRot);
            }

            @NotNull
            public RotData fromNetwork(@NotNull ParticleType<RotData> particleTypeIn, FriendlyByteBuf buffer) {
                return new RotData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public static Codec<RotData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("xRot").forGetter(RotData::xRot), (App)Codec.FLOAT.fieldOf("yRot").forGetter(RotData::yRot), (App)Codec.FLOAT.fieldOf("zRot").forGetter(RotData::zRot)).apply((Applicative)codecBuilder, RotData::new));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.xRot);
            buffer.writeFloat(this.yRot);
            buffer.writeFloat(this.zRot);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.xRot), Float.valueOf(this.yRot), Float.valueOf(this.zRot));
        }

        @NotNull
        public ParticleType<RotData> m_6012_() {
            return ParticleInit.DUCK_LARGE_VERTICAL_RIPPLE.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record RotFactory(SpriteSet spriteSet) implements ParticleProvider<RotData>
    {
        public Particle createParticle(RotData data, @NotNull ClientLevel level, double x, double y, double z, double xs, double ys, double zs) {
            return new DuckLargeVerticalRippleParticle(level, x, y, z, xs, ys, zs, data.xRot(), data.yRot(), data.zRot(), this.spriteSet);
        }
    }
}

