/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractTrailParticle;
import vzling.lib.init.ParticleInit;

@OnlyIn(value=Dist.CLIENT)
public class EntityTrailParticle
extends AbstractTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("vzling", "textures/particle/entity_trail.png");
    private final int entityId;

    public EntityTrailParticle(ClientLevel world, double x, double y, double z, int r, int g, int b, int entityId) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.f_107225_ = Integer.MAX_VALUE;
        this.f_107226_ = 0.0f;
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.entityId = entityId;
    }

    @Override
    public void m_5989_() {
        float fade = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.trailA = 0.8f * fade;
        Entity entity = this.f_107208_.m_6815_(this.entityId);
        if (entity != null) {
            Vec3 vec = entity.m_20182_().m_82546_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_)).m_82520_(0.0, 0.25, 0.0);
            this.f_107215_ = vec.m_7096_();
            this.f_107216_ = vec.m_7098_();
            this.f_107217_ = vec.m_7094_();
        } else {
            this.m_107274_();
        }
        super.m_5989_();
    }

    public int m_6355_(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 1.0f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public record ColorData(int r, int g, int b, int entityId) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<ColorData> DESERIALIZER = new ParticleOptions.Deserializer<ColorData>(){

            @NotNull
            public ColorData fromCommand(@NotNull ParticleType<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                int entityId = reader.readInt();
                return new ColorData(r, g, b, entityId);
            }

            @NotNull
            public ColorData fromNetwork(@NotNull ParticleType<ColorData> particleTypeIn, FriendlyByteBuf buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b), (App)Codec.INT.fieldOf("entityId").forGetter(ColorData::entityId)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeInt(this.entityId);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b, this.entityId);
        }

        @NotNull
        public ParticleType<ColorData> m_6012_() {
            return ParticleInit.ENTITY_TRAIL.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ColorData> {
        public Particle createParticle(ColorData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EntityTrailParticle(level, x, y, z, data.r(), data.g(), data.b(), data.entityId());
        }
    }
}

