/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.renderer.LaserBeamRenderer;
import vzling.lib.entity.ExampleLaserBeamEntity;

@OnlyIn(value=Dist.CLIENT)
public class ExampleLaserBeamEntityRenderer<T extends ExampleLaserBeamEntity>
extends LaserBeamRenderer<T> {
    public ExampleLaserBeamEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public float getBeamRadius(T entity) {
        return 0.6f;
    }

    @Override
    public void renderBeamPart(T entity, float length, float tickCount, float partialTicks, PoseStack stack, VertexConsumer consumer, int light) {
        PoseStack.Pose pose = stack.m_85850_();
        float factor = (float)Math.sin(tickCount);
        float xOffset = tickCount * 0.025f % this.getTextureWidth();
        float progress = 1.0f;
        if (((ExampleLaserBeamEntity)((Object)entity)).f_19797_ <= 10) {
            progress = tickCount / 10.0f;
        }
        if (((ExampleLaserBeamEntity)((Object)entity)).deathTime > 0) {
            progress = 1.0f - ((float)((ExampleLaserBeamEntity)((Object)entity)).deathTime + partialTicks) / 10.0f;
        }
        this.vertex(pose, consumer, (-this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f) * progress, 0.0f, 0.0f, -xOffset, 0.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
        this.vertex(pose, consumer, (-this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f) * progress, length, 0.0f, 1.0f - xOffset, 0.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
        this.vertex(pose, consumer, (this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f) * progress, length, 0.0f, 1.0f - xOffset, 1.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
        this.vertex(pose, consumer, (this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f) * progress, 0.0f, 0.0f, -xOffset, 1.0f, ((ExampleLaserBeamEntity)((Object)entity)).isDead ? progress : 1.0f, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return new ResourceLocation("vzling", "textures/entity/example_laser_beam.png");
    }
}

