/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import vzling.lib.client.particle.OrbLightningParticle;
import vzling.lib.entity.RayAttack;
import vzling.lib.init.EntityInit;
import vzling.lib.init.ItemInit;
import vzling.lib.init.ParticleInit;

public class ExampleLaserBeamEntity
extends RayAttack {
    public int deathTime = 0;
    public boolean isDead = false;

    public ExampleLaserBeamEntity(EntityType<? extends RayAttack> type, Level level) {
        super(type, level);
    }

    public ExampleLaserBeamEntity(Level level, LivingEntity caster, double x, double y, double z, float yaw, float pitch) {
        super(EntityInit.EXAMPLE_LASER_BEAM.get(), level, caster, x, y, z, yaw, pitch);
        this.m_6034_(x, y - 0.5, z);
    }

    @Override
    public float getAttackDamage() {
        return 3.5f;
    }

    @Override
    public void addEndParticles(Vec3 endPos) {
        super.addEndParticles(endPos);
        if (!this.m_9236_().m_8055_(new BlockPos((int)endPos.m_7096_(), (int)endPos.m_7098_(), (int)endPos.m_7094_()).m_7495_()).m_60795_() && this.f_19797_ % 3 == 2) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleInit.SCORCH.get(), true, endPos.f_82479_ + (double)this.f_19796_.m_188501_() - 0.5, endPos.f_82480_, endPos.f_82481_ + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.updatePosition();
        Vec3 vec3 = this.m_20184_();
        double d3 = this.m_20185_() + vec3.f_82479_;
        double d4 = this.m_20186_() + vec3.f_82480_ + 0.0;
        double d5 = this.m_20189_() + vec3.f_82481_;
        int r = 122 + this.f_19796_.m_188503_(1);
        int g = 63 + this.f_19796_.m_188503_(1);
        int b = 205 + this.f_19796_.m_188503_(1);
        double xOffset = this.f_19796_.m_188500_() * 1.5 - 0.75;
        double yOffset = this.f_19796_.m_188500_() * 1.5 - 0.75 + 0.0;
        double zOffset = this.f_19796_.m_188500_() * 1.5 - 0.75;
        this.m_9236_().m_7106_((ParticleOptions)new OrbLightningParticle.OrbData(r, g, b), this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, d3, d4, d5);
    }

    @Override
    public void updatePosition() {
        if (this.f_19797_ % 3 == 0) {
            this.m_5496_(SoundEvents.f_11737_, 1.0f, 1.2f);
        }
        this.getCaster().ifPresentOrElse(caster -> {
            Player player;
            ItemStack useItem;
            this.m_146884_(this.getPositionForCaster((Entity)caster, caster.m_20182_()));
            if (caster instanceof Player && ((useItem = (player = (Player)caster).m_21211_()).m_41619_() || !useItem.m_150930_(ItemInit.LASER_STAFF.get()))) {
                this.isDead = true;
            }
        }, () -> {
            this.isDead = true;
        });
        if (this.isDead) {
            ++this.deathTime;
        }
        if (this.deathTime >= 10) {
            this.m_146870_();
        }
    }

    @Override
    public void doHurtTarget(LivingEntity target) {
        if (!this.isDead) {
            super.doHurtTarget(target);
        }
    }

    @Override
    public Vec3 getPositionForCaster(Entity caster, Vec3 casterPos) {
        return casterPos.m_82520_(0.0, (double)caster.m_20236_(caster.m_20089_()) - 0.3, 0.0);
    }

    @Override
    public float getRotationSpeed() {
        return 0.5f;
    }
}

