/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity.dialog;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import vzling.lib.client.screen.DialogScreen;
import vzling.lib.entity.dialog.AbstractDialog;
import vzling.lib.entity.dialog.DialogOption;

public class OptionDialog
extends AbstractDialog {
    private final List<DialogOption> options = new ArrayList<DialogOption>();

    public OptionDialog(int id, Component component, int color, int typingSpeed, boolean isShake) {
        super(id, component, color, typingSpeed, isShake);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, int tick) {
        String text = this.getComponent().getString();
        int chars = Math.min(text.length(), tick / this.getTypeSpeed());
        String visible = text.substring(0, chars);
        int xOffset = x + 10;
        int yOffset = y + 10;
        if (this.isShake() && chars > 0) {
            xOffset += Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)1);
            yOffset += Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)1);
        }
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, visible, xOffset, yOffset, this.getColor());
        if (this.isFinished(tick)) {
            int textDuration = this.getComponent().getString().length() * this.getTypeSpeed();
            int baseTick = tick - textDuration;
            int xOffset2 = x + 10;
            int yOffset2 = y + 20;
            for (int i = 0; i < this.getOptions().size(); ++i) {
                DialogOption option = this.getOptions().get(i);
                int charsOption = Math.min(option.component().getString().length(), baseTick / option.typeSpeed());
                if (charsOption > 0) {
                    int renderX = xOffset2;
                    int renderY = yOffset2;
                    if (option.isShake()) {
                        renderX += Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)1);
                        renderY += Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)1);
                    }
                    String visibleOption = option.component().getString().substring(0, charsOption);
                    Screen screen = Minecraft.m_91087_().f_91080_;
                    if (screen instanceof DialogScreen) {
                        DialogScreen screen2 = (DialogScreen)screen;
                        int selectedOption = screen2.getSelectedOption();
                        int color = i == selectedOption ? 0xFFFF00 : option.color();
                        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (i == selectedOption ? "> " : "  ") + visibleOption, renderX, renderY, color);
                    }
                }
                yOffset2 += 12;
            }
        }
    }

    public OptionDialog addOption(DialogOption option) {
        this.options.add(option);
        return this;
    }

    public List<DialogOption> getOptions() {
        return this.options;
    }
}

