/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.forge.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import vzling.lib.client.handler.VzlingClientHandler;

public record ScreenShakePacket(float magnitude, int duration) {
    public static void encode(ScreenShakePacket packet, FriendlyByteBuf buf) {
        buf.writeFloat(packet.magnitude);
        buf.writeInt(packet.duration);
    }

    public static ScreenShakePacket decode(FriendlyByteBuf buf) {
        return new ScreenShakePacket(buf.readFloat(), buf.readInt());
    }

    public static void handle(ScreenShakePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientHandler.handle(packet));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        static void handle(ScreenShakePacket packet) {
            VzlingClientHandler.startShake(packet.magnitude, packet.duration, (Entity)Minecraft.m_91087_().f_91074_);
        }
    }
}

