/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.forge.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import vzling.lib.animation.VzlingAnimatable;

public record SendAnimationPacket(int type, int entityId, ResourceLocation animationId) {
    public static void encode(SendAnimationPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.type);
        buf.writeInt(packet.entityId);
        buf.m_130085_(packet.animationId);
    }

    public static SendAnimationPacket decode(FriendlyByteBuf buf) {
        return new SendAnimationPacket(buf.readInt(), buf.readInt(), buf.m_130281_());
    }

    public static void handle(SendAnimationPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity patt0$temp;
            if (Minecraft.m_91087_().f_91073_ != null && (patt0$temp = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId)) instanceof VzlingAnimatable) {
                VzlingAnimatable animatable = (VzlingAnimatable)patt0$temp;
                Entity patt1$temp = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId);
                if (patt1$temp instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)patt1$temp;
                    switch (packet.type) {
                        case 0: {
                            animatable.playAnimation((Entity)entity, packet.animationId);
                            break;
                        }
                        case 1: {
                            animatable.playAnimationIfStopped((Entity)entity, packet.animationId);
                            break;
                        }
                        case 2: {
                            animatable.stopAnimation((Entity)entity, packet.animationId);
                        }
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

