/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import vzling.lib.client.particle.AbstractTrailParticle;
import vzling.lib.init.ParticleInit;

@Environment(value=EnvType.CLIENT)
public class SpinTrailParticle
extends AbstractTrailParticle {
    private static final class_2960 PROTON_TRAIL_TEXTURE = new class_2960("vzling", "textures/particle/entity_trail.png");
    protected double orbitX;
    protected double orbitY;
    protected double orbitZ;
    protected double orbitDistance;
    protected class_243 orbitOffset;
    protected boolean reverseOrbit;
    protected int orbitAxis;
    protected float orbitSpeed = 1.0f;

    public SpinTrailParticle(class_638 world, double x, double y, double z, double xd, double yd, double zd, int r, int g, int b) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.trailA = 0.8f;
        this.field_3847 = 50 + this.field_3840.method_43048(30);
        this.field_3844 = 0.0f;
        this.orbitX = xd;
        this.orbitY = yd;
        this.orbitZ = zd;
        this.orbitDistance = 4.0;
        this.orbitOffset = new class_243(0.0, 0.0, 0.0);
        this.reverseOrbit = this.field_3840.method_43056();
        this.orbitAxis = this.field_3840.method_43048(2);
        this.orbitSpeed = 10.0f;
    }

    public class_243 getOrbitPosition(float angle) {
        class_243 center = new class_243(this.orbitX, this.orbitY, this.orbitZ);
        float f = this.reverseOrbit ? -1.0f : 1.0f;
        class_243 add = class_243.field_1353;
        float rot = angle * 3.0f * this.orbitSpeed * ((float)Math.PI / 180);
        add = switch (this.orbitAxis) {
            case 0 -> new class_243(0.0, this.orbitDistance * 0.5, this.orbitDistance * 0.5).method_1037(rot * f);
            case 1 -> new class_243(this.orbitDistance * 0.5, 0.0, this.orbitDistance * 0.5).method_1024(rot * f);
            case 2 -> new class_243(this.orbitDistance * 0.5, this.orbitDistance * 0.5, 0.0).method_31033(rot * f);
            default -> add;
        };
        return center.method_1019(add);
    }

    @Override
    public void method_3070() {
        class_243 vec3 = this.getOrbitPosition(this.field_3866);
        class_243 movement = vec3.method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029().method_1021((double)(this.orbitSpeed * 0.01f));
        this.field_3852 += movement.field_1352;
        this.field_3869 += movement.field_1351;
        this.field_3850 += movement.field_1350;
        float fade = 1.0f - (float)this.field_3866 / (float)this.field_3847;
        this.trailA = 0.8f * fade;
        super.method_3070();
    }

    public int method_3068(float f) {
        return 240;
    }

    @Override
    public float getTrailHeight() {
        return 0.2f;
    }

    @Override
    public class_2960 getTrailTexture() {
        return PROTON_TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.field_3847 - this.field_3866);
    }

    public record SpinData(int r, int g, int b) implements class_2394
    {
        public static final class_2394.class_2395<SpinData> DESERIALIZER = new class_2394.class_2395<SpinData>(){

            @NotNull
            public SpinData fromCommand(@NotNull class_2396<SpinData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                return new SpinData(r, g, b);
            }

            @NotNull
            public SpinData fromNetwork(@NotNull class_2396<SpinData> particleTypeIn, class_2540 buffer) {
                return new SpinData(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        };

        public static Codec<SpinData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(SpinData::r), (App)Codec.INT.fieldOf("g").forGetter(SpinData::g), (App)Codec.INT.fieldOf("b").forGetter(SpinData::b)).apply((Applicative)codecBuilder, SpinData::new));
        }

        public void method_10294(class_2540 buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
        }

        @NotNull
        public String method_10293() {
            return String.format(Locale.ROOT, "%s %d %d %d", class_7923.field_41180.method_10221(this.method_10295()), this.r, this.g, this.b);
        }

        @NotNull
        public class_2396<SpinData> method_10295() {
            return ParticleInit.SPIN_TRAIL.get();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<SpinData> {
        public class_703 createParticle(SpinData data, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SpinTrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.r(), data.g(), data.b());
        }
    }
}

