/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.client.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Quaternionf;
import vzling.lib.client.renderer.VzlingRenderType;
import vzling.lib.entity.RayAttack;
import vzling.lib.entity.RayAttackUser;
import vzling.lib.util.MathUtil;

@Environment(value=EnvType.CLIENT)
public abstract class LaserBeamRenderer<T extends RayAttack>
extends class_897<T> {
    private boolean playerCast = false;

    public LaserBeamRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public float getTextureWidth() {
        return 128.0f;
    }

    public float getBeamRadius(T entity) {
        return 1.0f;
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferSource, int light) {
        RayAttackUser user;
        class_1297 class_12972;
        double entityX = class_3532.method_16436((double)partialTicks, (double)((RayAttack)((Object)entity)).field_6014, (double)entity.method_23317());
        double entityY = class_3532.method_16436((double)partialTicks, (double)((RayAttack)((Object)entity)).field_6036, (double)entity.method_23318());
        double entityZ = class_3532.method_16436((double)partialTicks, (double)((RayAttack)((Object)entity)).field_5969, (double)entity.method_23321());
        stack.method_22903();
        if (((RayAttack)((Object)entity)).getCaster().isPresent()) {
            class_1297 caster = ((RayAttack)((Object)entity)).getCaster().get();
            double posX = class_3532.method_16436((double)partialTicks, (double)caster.field_6014, (double)caster.method_23317());
            double posY = class_3532.method_16436((double)partialTicks, (double)caster.field_6036, (double)caster.method_23318());
            double posZ = class_3532.method_16436((double)partialTicks, (double)caster.field_5969, (double)caster.method_23321());
            class_243 pos = ((RayAttack)((Object)entity)).getPositionForCaster(caster, new class_243(posX, posY, posZ));
            posX = pos.field_1352;
            posY = pos.field_1351;
            posZ = pos.field_1350;
            stack.method_22904(posX - entityX, posY - entityY, posZ - entityZ);
        }
        boolean bl = this.playerCast = class_310.method_1551().field_1690.method_31044().method_31034() && ((RayAttack)((Object)entity)).getCaster().isPresent() && class_310.method_1551().field_1724 != null && ((RayAttack)((Object)entity)).getCaster().get().method_5667().equals(class_310.method_1551().field_1724.method_5667());
        if (this.playerCast && class_310.method_1551().method_1560() != null) {
            class_243 offset = MathUtil.rotationToPosition(0.5f, -class_310.method_1551().method_1560().method_36455() - 90.0f, class_310.method_1551().method_1560().method_5791() + 90.0f);
            stack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        }
        float yaw = class_3532.method_16439((float)partialTicks, (float)((RayAttack)((Object)entity)).prevYaw, (float)((RayAttack)((Object)entity)).getYaw()) * ((float)Math.PI / 180);
        float pitch = class_3532.method_16439((float)partialTicks, (float)((RayAttack)((Object)entity)).prevPitch, (float)((RayAttack)((Object)entity)).getPitch()) * ((float)Math.PI / 180);
        if (((RayAttack)((Object)entity)).getCaster().isPresent() && ((class_12972 = ((RayAttack)((Object)entity)).getCaster().get()) instanceof RayAttackUser && (user = (RayAttackUser)class_12972).isRayFollowingHeadRotation() || !(((RayAttack)((Object)entity)).getCaster().get() instanceof RayAttackUser)) && (class_12972 = ((RayAttack)((Object)entity)).getCaster().get()) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            yaw = (living.method_5705(partialTicks) + 90.0f) * ((float)Math.PI / 180);
            pitch = -living.method_5695(partialTicks) * ((float)Math.PI / 180);
        }
        float length = ((RayAttack)((Object)entity)).getLength();
        class_4588 consumer = bufferSource.getBuffer(VzlingRenderType.getEntityGlowEffect(this.method_3931((class_1297)entity)));
        this.renderBeam(entity, length, yaw, pitch, (float)((RayAttack)((Object)entity)).field_6012 + partialTicks, partialTicks, stack, consumer, light);
        stack.method_22909();
    }

    public void renderBeamPart(T entity, float length, float tickCount, float partialTicks, class_4587 stack, class_4588 consumer, int light) {
        class_4587.class_4665 pose = stack.method_23760();
        float factor = (float)Math.sin(tickCount);
        float xOffset = tickCount * 0.025f % this.getTextureWidth();
        this.vertex(pose, consumer, -this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f, 0.0f, 0.0f, -xOffset, 0.0f, 1.0f, light);
        this.vertex(pose, consumer, -this.getBeamRadius(entity) * 0.7f - factor * this.getBeamRadius(entity) * 0.2f, length, 0.0f, 1.0f - xOffset, 0.0f, 1.0f, light);
        this.vertex(pose, consumer, this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f, length, 0.0f, 1.0f - xOffset, 1.0f, 1.0f, light);
        this.vertex(pose, consumer, this.getBeamRadius(entity) * 0.7f + factor * this.getBeamRadius(entity) * 0.2f, 0.0f, 0.0f, -xOffset, 1.0f, 1.0f, light);
    }

    public void renderBeam(T entity, float length, float yaw, float pitch, float tickCount, float partialTicks, class_4587 poseStack, class_4588 vertexConsumer, int light) {
        poseStack.method_22903();
        poseStack.method_22907(new Quaternionf().rotationX(1.5707964f));
        poseStack.method_22907(new Quaternionf().rotationZ(yaw - 1.5707964f));
        poseStack.method_22907(new Quaternionf().rotationX(-pitch));
        poseStack.method_22903();
        if (!this.playerCast) {
            poseStack.method_22907(new Quaternionf().rotationY(tickCount * ((float)Math.PI / 180)));
        }
        this.renderBeamPart(entity, length, tickCount, partialTicks, poseStack, vertexConsumer, light);
        poseStack.method_22909();
        if (!this.playerCast) {
            for (int i = 1; i < 2; ++i) {
                poseStack.method_22903();
                poseStack.method_22907(new Quaternionf().rotationY((float)(i * 45) * ((float)Math.PI / 180)));
                this.renderBeamPart(entity, length, tickCount, partialTicks, poseStack, vertexConsumer, light);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    public void vertex(class_4587.class_4665 pose, class_4588 consumer, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int light) {
        consumer.method_22918(pose.method_23761(), offsetX, offsetY, offsetZ).method_22915(1.0f, 1.0f, 1.0f, 1.0f * alpha).method_22913(textureX, textureY).method_22922(class_4608.field_21444).method_22916(light).method_23763(pose.method_23762(), 0.0f, 1.0f, 0.0f).method_1344();
    }
}

