/*
 * Decompiled with CFR 0.152.
 */
package vzling.lib.entity;

import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.lib.entity.AbstractSkillEntity;

public abstract class BossEntity
extends AbstractSkillEntity {
    public static final class_2940<Integer> PHASE = class_2945.method_12791(BossEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SPAWNED = class_2945.method_12791(BossEntity.class, (class_2941)class_2943.field_13323);
    public int phaseTick = 0;
    public boolean updatePhase = false;
    public int spawnTick = 0;
    private int reducedDamageTicks;

    public BossEntity(class_1299<? extends class_1588> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PHASE, (Object)1);
        this.field_6011.method_12784(SPAWNED, (Object)false);
    }

    @Override
    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Phase", this.getPhase());
        tag.method_10556("Spawned", this.isSpawned());
    }

    @Override
    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Phase")) {
            this.setPhase(tag.method_10550("Phase"));
        }
        if (tag.method_10545("Spawned")) {
            this.setSpawned(tag.method_10577("Spawned"));
        }
    }

    public boolean method_37222(class_1293 instance, @Nullable class_1297 entity) {
        return instance.method_5579().method_5573() && super.method_37222(instance, entity);
    }

    public void method_26082(class_1293 instance, @Nullable class_1297 entity) {
        if (instance.method_5579().method_5573()) {
            super.method_26082(instance, entity);
        }
    }

    protected void method_6099(class_1282 source, int looting, boolean recentlyHit) {
    }

    @Nullable
    public class_1315 method_5943(class_5425 levelAccessor, class_1266 instance, class_3730 spawnType, @Nullable class_1315 groupData, @Nullable class_2487 tag) {
        return groupData;
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public void method_6005(double scale, double x, double y) {
    }

    public void method_5773() {
        super.method_5773();
        if (this.reducedDamageTicks > 0) {
            --this.reducedDamageTicks;
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_5987() && this.method_5805()) {
            this.updatePhase();
            if (this.hasSpawnProcess()) {
                this.spawn();
            } else if (!this.isSpawned()) {
                this.setSpawned(true);
            }
        }
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public abstract void updatePhase();

    public abstract void spawn();

    public abstract boolean hasSpawnProcess();

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public void setPhase(int phase) {
        this.field_6011.method_12778(PHASE, (Object)phase);
    }

    public boolean isSpawned() {
        return (Boolean)this.field_6011.method_12789(SPAWNED);
    }

    public void setSpawned(boolean spawned) {
        this.field_6011.method_12778(SPAWNED, (Object)spawned);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42242)) {
            return super.method_5643(source, amount);
        }
        if (!this.isSpawned() || this.updatePhase) {
            return false;
        }
        if (this.getDamageTime() > 0 && this.reducedDamageTicks > 0) {
            amount *= 1.0f - (float)this.reducedDamageTicks / (float)this.getDamageTime();
        }
        boolean flag = super.method_5643(source, Math.min(amount, this.getDamageMap()));
        if (this.getDamageTime() > 0 && flag) {
            this.reducedDamageTicks = this.getDamageTime();
        }
        return flag;
    }

    public int getDamageTime() {
        return 0;
    }

    public float getDamageMap() {
        return Float.MAX_VALUE;
    }
}

