/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync;

import com.mojang.logging.LogUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.minecraft.SharedConstants;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import vip.fubuki.playersync.config.JdbcConfig;
import vip.fubuki.playersync.sync.ChatSync;
import vip.fubuki.playersync.sync.VanillaSync;
import vip.fubuki.playersync.util.JDBCsetUp;

@Mod(value="playersync")
public class PlayerSync {
    public static final String MODID = "playersync";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PlayerSync(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)JdbcConfig.COMMON_CONFIG);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        try {
            DriverManager.registerDriver((Driver)new com.mysql.cj.jdbc.Driver());
        }
        catch (SQLException e) {
            LOGGER.error("Unable to register JDBC MySQL driver", (Throwable)e);
        }
        VanillaSync.register();
        event.enqueueWork(() -> {
            if (((Boolean)JdbcConfig.SYNC_CHAT.get()).booleanValue()) {
                LOGGER.info("Chat sync enabled.");
                ChatSync.register();
            }
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) throws SQLException {
        String dataType;
        JDBCsetUp.QueryResult advColCheck;
        ResultSet rsAdvCol;
        String dbName = (String)JdbcConfig.DATABASE_NAME.get();
        JDBCsetUp.executeUpdateWithoutDatabase("CREATE DATABASE IF NOT EXISTS " + dbName, new Object[0]);
        try (Connection conn = JDBCsetUp.getConnection(false);
             Statement st = conn.createStatement();){
            st.execute("USE " + dbName);
        }
        catch (SQLException e) {
            LOGGER.error("Error selecting database " + dbName, (Throwable)e);
            throw e;
        }
        JDBCsetUp.executeUpdate("CREATE TABLE IF NOT EXISTS " + dbName + ".`player_data` (`uuid` char(36) NOT NULL,`inventory` mediumblob,`armor` blob,`advancements` blob,`enderchest` mediumblob,`effects` blob,`left_hand` blob,`cursors` blob,`xp` int DEFAULT NULL,`food_level` int DEFAULT NULL,`score` int DEFAULT NULL,`health` int DEFAULT NULL,`online` tinyint(1) DEFAULT NULL,`last_server` int DEFAULT NULL,PRIMARY KEY (`uuid`));", new Object[0]);
        JDBCsetUp.QueryResult queryResult = JDBCsetUp.executeQuery("SELECT COUNT(*) AS column_count FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" + dbName + "' AND TABLE_NAME = 'player_data';", new Object[0]);
        ResultSet resultSet = queryResult.resultSet();
        int columnCount = 0;
        if (resultSet.next()) {
            columnCount = resultSet.getInt("column_count");
        }
        if (columnCount < 14) {
            JDBCsetUp.executeUpdate("ALTER TABLE " + dbName + ".player_data ADD COLUMN left_hand blob, ADD COLUMN cursors blob;", new Object[0]);
        }
        JDBCsetUp.executeUpdate("CREATE TABLE IF NOT EXISTS " + dbName + ".server_info (`id` INT NOT NULL,`enable` boolean NOT NULL,`last_update` BIGINT NOT NULL,PRIMARY KEY (`id`));", new Object[0]);
        PlayerSync.addColumnIfNotExists("server_info", "data_version", "INT NOT NULL DEFAULT 0");
        long current = System.currentTimeMillis();
        int data_version = SharedConstants.m_183709_().m_183476_().m_193006_();
        JDBCsetUp.executeUpdate("INSERT INTO %s.server_info\n(\n    id,\n    enable,\n    data_version,\n    last_update\n)\nVALUES (\n    %d,\n    true,\n    %d,\n    %d\n)\nON DUPLICATE KEY UPDATE\n    id = %d,\n    enable = true,\n    data_version = %d,\n    last_update = %d;\n", dbName, JdbcConfig.SERVER_ID.get(), data_version, current, JdbcConfig.SERVER_ID.get(), data_version, current);
        if (ModList.get().isLoaded("curios")) {
            JDBCsetUp.executeUpdate("CREATE TABLE IF NOT EXISTS " + dbName + ".curios (uuid CHAR(36) NOT NULL, curios_item BLOB, PRIMARY KEY (uuid))", new Object[0]);
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            JDBCsetUp.executeUpdateWithoutDatabase("CREATE TABLE IF NOT EXISTS " + dbName + ".backpack_data (uuid CHAR(36) NOT NULL, backpack_nbt MEDIUMBLOB, PRIMARY KEY (uuid));", new Object[0]);
            PlayerSync.addColumnIfNotExists("backpack_data", "uuid", "CHAR(36) NOT NULL", true);
        }
        if ((rsAdvCol = (advColCheck = JDBCsetUp.executeQuery("SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" + dbName + "' AND TABLE_NAME = 'player_data' AND COLUMN_NAME = 'advancements';", new Object[0])).resultSet()).next() && !"mediumblob".equalsIgnoreCase(dataType = rsAdvCol.getString("DATA_TYPE"))) {
            LOGGER.info("Altering player_data table to modify 'advancements' column from {} to MEDIUMBLOB.", (Object)dataType);
            JDBCsetUp.executeUpdateWithoutDatabase("ALTER TABLE " + dbName + ".player_data MODIFY COLUMN advancements MEDIUMBLOB", new Object[0]);
        }
        rsAdvCol.close();
        LOGGER.info("PlayerSync is ready!");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ChatSync.shutdown();
    }

    private static void addColumnIfNotExists(String tableName, String columnName, String dataTypeDefaultNullness, boolean makePrimaryKey) throws SQLException {
        try (JDBCsetUp.QueryResult backpackColCheck = JDBCsetUp.executeQuery("SELECT COUNT(*) AS colCount FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE()AND TABLE_NAME = '" + tableName + "' AND COLUMN_NAME = '" + columnName + "';", new Object[0]);){
            ResultSet rsBackpackCol = backpackColCheck.resultSet();
            if (!rsBackpackCol.next()) {
                LOGGER.warn("Warning: Unable to check existence of colum {} in table {}.", (Object)columnName, (Object)tableName);
                return;
            }
            if (rsBackpackCol.getInt("colCount") > 0) {
                LOGGER.debug("Column {} already exists. Skipping creation.", (Object)columnName);
                return;
            }
        }
        LOGGER.info("ALTER {} table to add missing {} column.", (Object)tableName, (Object)columnName);
        JDBCsetUp.executeUpdate("ALTER TABLE %s ADD COLUMN %s %s", tableName, columnName, dataTypeDefaultNullness);
        if (makePrimaryKey) {
            LOGGER.info("Altering {} table to add primary key on {}.", (Object)tableName, (Object)columnName);
            JDBCsetUp.executeUpdate("ALTER TABLE %s ADD PRIMARY KEY (%s)", tableName, columnName);
        }
    }

    private static void addColumnIfNotExists(String tableName, String columnName, String dataTypeDefaultNullness) throws SQLException {
        PlayerSync.addColumnIfNotExists(tableName, columnName, dataTypeDefaultNullness, false);
    }
}

