/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync.sync;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraftforge.common.MinecraftForge;
import org.slf4j.Logger;
import vip.fubuki.playersync.config.JdbcConfig;
import vip.fubuki.playersync.sync.chat.ChatSyncClient;
import vip.fubuki.playersync.sync.chat.ChatSyncServer;

public class ChatSync {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ChatSyncServer chatSyncServer;
    private static ChatSyncClient chatSyncClient;

    public static void register() {
        if (((Boolean)JdbcConfig.IS_CHAT_SERVER.get()).booleanValue()) {
            LOGGER.info("Trying to setup chat server at port " + String.valueOf(JdbcConfig.CHAT_SERVER_PORT.get()));
            new Thread(() -> {
                chatSyncServer = new ChatSyncServer();
                try {
                    chatSyncServer.run();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to start chat server", (Throwable)e);
                }
            }, "ChatSync-Server").start();
        }
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.info("Trying to connect to chat server " + (String)JdbcConfig.CHAT_SERVER_IP.get() + ":" + String.valueOf(JdbcConfig.CHAT_SERVER_PORT.get()));
            chatSyncClient = new ChatSyncClient();
            chatSyncClient.run();
        }, "ChatSync-Client").start();
        MinecraftForge.EVENT_BUS.register(ChatSyncClient.class);
    }

    public static void shutdown() {
        if (chatSyncServer != null) {
            chatSyncServer.shutdown();
        }
        if (chatSyncClient != null) {
            chatSyncClient.shutdown();
        }
    }
}

