/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync.sync;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import vip.fubuki.playersync.PlayerSync;
import vip.fubuki.playersync.sync.VanillaSync;
import vip.fubuki.playersync.util.JDBCsetUp;
import vip.fubuki.playersync.util.LocalJsonUtil;

public class ModsSupport {
    public void onPlayerJoin(Player player) throws SQLException {
        if (ModList.get().isLoaded("curios")) {
            LazyOptional handlerOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
            JDBCsetUp.QueryResult qr = JDBCsetUp.executeQuery("SELECT curios_item FROM curios WHERE uuid = '" + String.valueOf(player.m_20148_()) + "'", new Object[0]);
            ResultSet rs = qr.resultSet();
            if (rs.next()) {
                String curiosData = rs.getString("curios_item");
                Map<String, String> storedMap = LocalJsonUtil.StringToMap(curiosData);
                handlerOpt.ifPresent(handler -> handler.getCurios().forEach((slotType, stacksHandler) -> {
                    IDynamicStackHandler dynStacks = stacksHandler.getStacks();
                    for (int i = 0; i < dynStacks.getSlots(); ++i) {
                        dynStacks.setStackInSlot(i, ItemStack.f_41583_);
                    }
                }));
                if (curiosData.length() <= 2) {
                    rs.close();
                    qr.connection().close();
                    return;
                }
                handlerOpt.ifPresent(handler -> {
                    for (Map.Entry entry : storedMap.entrySet()) {
                        int slotIndex;
                        String compositeKey = (String)entry.getKey();
                        String[] parts = compositeKey.split(":");
                        if (parts.length != 2) continue;
                        String slotType = parts[0];
                        try {
                            slotIndex = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException ex) {
                            continue;
                        }
                        String serialized = (String)entry.getValue();
                        try {
                            ICurioStacksHandler stacksHandler;
                            IDynamicStackHandler dynStacks;
                            ItemStack stack = VanillaSync.deserializeAndCreatePlaceholderIfNeeded(serialized);
                            if (!handler.getCurios().containsKey(slotType) || slotIndex >= (dynStacks = (stacksHandler = (ICurioStacksHandler)handler.getCurios().get(slotType)).getStacks()).getSlots()) continue;
                            dynStacks.setStackInSlot(slotIndex, stack);
                        }
                        catch (CommandSyntaxException e) {
                            throw new RuntimeException("Error deserializing Curio data for key " + compositeKey, e);
                        }
                    }
                });
                rs.close();
                qr.connection().close();
            } else {
                this.StoreCurios(player, true);
            }
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            PlayerSync.LOGGER.info("Restoring backpack data for player " + String.valueOf(player.m_20148_()));
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpackItem, handler, identifier, slot) -> {
                backpackItem.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
                    Optional uuidOpt = NBTHelper.getUniqueId((ItemStack)wrapper.getBackpack(), (String)"contentsUuid");
                    if (uuidOpt.isPresent()) {
                        UUID contentsUuid = (UUID)uuidOpt.get();
                        try {
                            JDBCsetUp.QueryResult qrBackpack = JDBCsetUp.executeQuery("SELECT backpack_nbt FROM backpack_data WHERE uuid='" + String.valueOf(contentsUuid) + "'", new Object[0]);
                            ResultSet rsBackpack = qrBackpack.resultSet();
                            if (rsBackpack.next()) {
                                String serialized = rsBackpack.getString("backpack_nbt");
                                String nbtString = VanillaSync.deserializeString(serialized);
                                CompoundTag backpackNbt = NbtUtils.m_178024_((String)nbtString);
                                BackpackStorage.get().setBackpackContents(contentsUuid, backpackNbt);
                                PlayerSync.LOGGER.info("Restored backpack data for UUID " + String.valueOf(contentsUuid));
                            }
                            rsBackpack.close();
                            qrBackpack.connection().close();
                        }
                        catch (SQLException e) {
                            PlayerSync.LOGGER.error("Error restoring backpack data for UUID " + String.valueOf(contentsUuid), (Throwable)e);
                        }
                        catch (CommandSyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        PlayerSync.LOGGER.warn("Backpack item in slot " + slot + " has no contentsUuid during restore");
                    }
                });
                return false;
            });
        }
    }

    public void onPlayerLeave(Player player) throws SQLException {
        if (ModList.get().isLoaded("curios")) {
            this.StoreCurios(player, false);
        }
    }

    public void StoreCurios(Player player, boolean init) throws SQLException {
        LazyOptional handlerOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
        HashMap flatMap = new HashMap();
        handlerOpt.ifPresent(handler -> handler.getCurios().forEach((slotType, stacksHandler) -> {
            IDynamicStackHandler dynStacks = stacksHandler.getStacks();
            for (int i = 0; i < dynStacks.getSlots(); ++i) {
                ItemStack stack = dynStacks.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                String serialized = VanillaSync.serialize(stack.serializeNBT().toString());
                flatMap.put(slotType + ":" + i, serialized);
            }
        }));
        String serializedData = ((Object)flatMap).toString();
        if (init) {
            JDBCsetUp.executeUpdate("INSERT INTO curios (uuid,curios_item) VALUES ('" + String.valueOf(player.m_20148_()) + "', '" + serializedData + "')", new Object[0]);
        } else {
            JDBCsetUp.executeUpdate("UPDATE curios SET curios_item = '" + serializedData + "' WHERE uuid = '" + String.valueOf(player.m_20148_()) + "'", new Object[0]);
        }
    }

    public static void storeSophisticatedBackpacks(Player player) {
        PlayerSync.LOGGER.info("Storing backpack data for player " + String.valueOf(player.m_20148_()));
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpackItem, handler, identifier, slot) -> {
            backpackItem.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
                Optional uuidOpt = NBTHelper.getUniqueId((ItemStack)wrapper.getBackpack(), (String)"contentsUuid");
                if (uuidOpt.isPresent()) {
                    UUID contentsUuid = (UUID)uuidOpt.get();
                    CompoundTag backpackNbt = BackpackStorage.get().getOrCreateBackpackContents(contentsUuid);
                    String serialized = VanillaSync.serialize(backpackNbt.toString());
                    try {
                        JDBCsetUp.executeUpdate("REPLACE INTO backpack_data (uuid, backpack_nbt) VALUES ('" + String.valueOf(contentsUuid) + "', '" + serialized + "')", new Object[0]);
                        PlayerSync.LOGGER.info("Saved backpack data for UUID " + String.valueOf(contentsUuid));
                    }
                    catch (SQLException e) {
                        PlayerSync.LOGGER.error("Error saving backpack data for UUID " + String.valueOf(contentsUuid), (Throwable)e);
                    }
                } else {
                    PlayerSync.LOGGER.warn("Backpack item in slot " + slot + " has no contentsUuid");
                }
            });
            return false;
        });
    }
}

