/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync.sync;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerNegotiationEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import vip.fubuki.playersync.PlayerSync;
import vip.fubuki.playersync.config.JdbcConfig;
import vip.fubuki.playersync.sync.ModsSupport;
import vip.fubuki.playersync.util.JDBCsetUp;
import vip.fubuki.playersync.util.LocalJsonUtil;
import vip.fubuki.playersync.util.PSThreadPoolFactory;

@Mod.EventBusSubscriber
public class VanillaSync {
    static ExecutorService executorService = Executors.newCachedThreadPool(new PSThreadPoolFactory("PlayerSync"));
    static int tick = 0;
    private static int autoSaveTickCounter = 0;
    private static final int AUTO_SAVE_INTERVAL_TICKS = 1200;

    public static void register() {
    }

    @SubscribeEvent
    public static void onDataPackSyncEvent(OnDatapackSyncEvent event) throws SQLException, IOException {
        if (!((Boolean)JdbcConfig.SYNC_ADVANCEMENTS.get()).booleanValue()) {
            return;
        }
        ServerPlayer serverPlayer = event.getPlayer();
        if (serverPlayer == null) {
            PlayerSync.LOGGER.debug("No player joining");
            return;
        }
        String player_uuid = serverPlayer.m_20148_().toString();
        PlayerSync.LOGGER.info("Player entity joining level " + player_uuid);
        JDBCsetUp.QueryResult advancementsQuery = JDBCsetUp.executeQuery("SELECT advancements FROM player_data WHERE uuid='" + player_uuid + "'", new Object[0]);
        ResultSet advancementsResultSet = advancementsQuery.resultSet();
        if (!advancementsResultSet.next()) {
            PlayerSync.LOGGER.debug("No advancements found for player " + player_uuid);
            advancementsResultSet.close();
            return;
        }
        File gameDir = Objects.requireNonNull(serverPlayer.m_20194_()).m_6237_();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.m_6982_()) {
            PlayerSync.LOGGER.debug("Attempting to write dedicated server advancement file");
            File advancements = new File(gameDir, VanillaSync.getSyncWorldForServer() + "/advancements/" + player_uuid + ".json");
            byte[] bytes = advancementsResultSet.getString("advancements").getBytes();
            advancementsResultSet.close();
            if (bytes.length < 2) {
                PlayerSync.LOGGER.debug("Skip writing advancements for player " + player_uuid);
                return;
            }
            File advancementsDir = advancements.getParentFile();
            if (advancementsDir != null && !advancementsDir.exists()) {
                PlayerSync.LOGGER.info("Creating advancements directory " + advancementsDir.getPath());
                boolean createdDir = advancementsDir.mkdirs();
                if (!createdDir) {
                    PlayerSync.LOGGER.error("Aborting advancements sync. Failed to create advancements directory at " + advancementsDir.getPath());
                    return;
                }
            }
            if (!advancements.exists()) {
                try {
                    PlayerSync.LOGGER.info("Creating new advancement file for player " + player_uuid);
                    advancements.createNewFile();
                }
                catch (IOException e) {
                    PlayerSync.LOGGER.error("Aborting advancements sync. Failed to create advancements file at " + advancements.getAbsolutePath(), (Throwable)e);
                    return;
                }
            }
            PlayerSync.LOGGER.debug("Writing advancement file " + String.valueOf(advancements.toPath()) + " for player " + player_uuid);
            PlayerSync.LOGGER.trace("Writing advancement file for player " + player_uuid + ": " + new String(bytes, StandardCharsets.UTF_8));
            Files.write(advancements.toPath(), bytes, new OpenOption[0]);
            PlayerAdvancements playeradvancements = serverPlayer.m_8960_();
            playeradvancements.m_135981_(server.m_129889_());
        } else {
            File[] files;
            PlayerSync.LOGGER.debug("Writing non-dedicated server advancement files");
            for (File file : files = VanillaSync.scanAdvancementsFile(player_uuid, gameDir)) {
                if (file == null) continue;
                byte[] bytes = advancementsResultSet.getString("advancements").getBytes();
                Files.write(file.toPath(), bytes, new OpenOption[0]);
            }
            advancementsResultSet.close();
        }
    }

    public static void doPlayerConnect(PlayerNegotiationEvent event) {
        block20: {
            try {
                int lastServer;
                boolean online;
                String player_uuid = event.getProfile().getId().toString();
                PlayerSync.LOGGER.info("Detected connection from player" + player_uuid + ",starting checking");
                JDBCsetUp.QueryResult qr1 = JDBCsetUp.executeQuery("SELECT online, last_server FROM player_data WHERE uuid='" + player_uuid + "'", new Object[0]);
                try (ResultSet rs1 = qr1.resultSet();){
                    if (!rs1.next()) {
                        PlayerSync.LOGGER.info("A new-player connection detected");
                        qr1.connection().close();
                        return;
                    }
                    online = rs1.getBoolean("online");
                    lastServer = rs1.getInt("last_server");
                    qr1.connection().close();
                }
                if (!online || lastServer == (Integer)JdbcConfig.SERVER_ID.get()) break block20;
                JDBCsetUp.QueryResult qr2 = JDBCsetUp.executeQuery("SELECT last_update,enable FROM server_info WHERE id='" + lastServer + "'", new Object[0]);
                try (ResultSet rs2 = qr2.resultSet();){
                    if (rs2.next()) {
                        long last_update = rs2.getLong("last_update");
                        boolean enable = rs2.getBoolean("enable");
                        if (enable && (double)System.currentTimeMillis() < (double)last_update + 300000.0) {
                            event.getConnection().m_129507_((Component)Component.m_237115_((String)"playersync.already_online"));
                            qr2.connection().close();
                            return;
                        }
                        JDBCsetUp.executeUpdate("UPDATE server_info SET enable= '0' WHERE id=" + lastServer, new Object[0]);
                    }
                    qr2.connection().close();
                }
            }
            catch (Exception e) {
                PlayerSync.LOGGER.error("SqlException detected!", (Throwable)e);
                event.getConnection().m_129507_((Component)Component.m_237115_((String)"playersync.sqlexception"));
            }
        }
    }

    public static void doPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            String player_uuid = event.getEntity().m_20148_().toString();
            PlayerSync.LOGGER.info("Starting synchronization for player " + player_uuid);
            JDBCsetUp.QueryResult qr1 = JDBCsetUp.executeQuery("SELECT online, last_server FROM player_data WHERE uuid='" + player_uuid + "'", new Object[0]);
            ResultSet rs1 = qr1.resultSet();
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            ModsSupport modsSupport = new ModsSupport();
            modsSupport.onPlayerJoin((Player)serverPlayer);
            if (!rs1.next()) {
                VanillaSync.store(event.getEntity(), true);
                JDBCsetUp.executeUpdate("UPDATE server_info SET last_update=" + System.currentTimeMillis() + " WHERE id=" + String.valueOf(JdbcConfig.SERVER_ID.get()), new Object[0]);
                JDBCsetUp.executeUpdate("UPDATE player_data SET online= '1',last_server=" + String.valueOf(JdbcConfig.SERVER_ID.get()) + " WHERE uuid='" + player_uuid + "'", new Object[0]);
                rs1.close();
                return;
            }
            JDBCsetUp.QueryResult qr2 = JDBCsetUp.executeQuery("SELECT * FROM player_data WHERE uuid='" + player_uuid + "'", new Object[0]);
            ResultSet rs2 = qr2.resultSet();
            JDBCsetUp.executeUpdate("UPDATE server_info SET last_update=" + System.currentTimeMillis() + " WHERE id=" + String.valueOf(JdbcConfig.SERVER_ID.get()), new Object[0]);
            JDBCsetUp.executeUpdate("UPDATE player_data SET online= '1',last_server=" + String.valueOf(JdbcConfig.SERVER_ID.get()) + " WHERE uuid='" + player_uuid + "'", new Object[0]);
            if (rs2.next()) {
                serverPlayer.m_21153_((float)rs2.getInt("health"));
                serverPlayer.m_36324_().m_38705_(rs2.getInt("food_level"));
                VanillaSync.setXpForPlayer(serverPlayer, rs2.getInt("xp"));
                serverPlayer.m_36397_(rs2.getInt("score"));
                String leftHandEncoded = rs2.getString("left_hand");
                serverPlayer.m_21008_(InteractionHand.OFF_HAND, VanillaSync.deserializeAndCreatePlaceholderIfNeeded(leftHandEncoded));
                String cursorsEncoded = rs2.getString("cursors");
                serverPlayer.f_36096_.m_142503_(VanillaSync.deserializeAndCreatePlaceholderIfNeeded(cursorsEncoded));
                String armor_data = rs2.getString("armor");
                if (armor_data.length() > 2) {
                    Map<Integer, String> equipment = LocalJsonUtil.StringToEntryMap(armor_data);
                    for (Map.Entry<Integer, String> entry : equipment.entrySet()) {
                        serverPlayer.m_150109_().f_35975_.set(entry.getKey().intValue(), (Object)VanillaSync.deserializeAndCreatePlaceholderIfNeeded(entry.getValue()));
                    }
                }
                Map<Integer, String> inventory = LocalJsonUtil.StringToEntryMap(rs2.getString("inventory"));
                for (Map.Entry<Integer, String> entry : inventory.entrySet()) {
                    serverPlayer.m_150109_().m_6836_(entry.getKey().intValue(), VanillaSync.deserializeAndCreatePlaceholderIfNeeded(entry.getValue()));
                }
                Map<Integer, String> ender_chest = LocalJsonUtil.StringToEntryMap(rs2.getString("enderchest"));
                for (Map.Entry<Integer, String> entry : ender_chest.entrySet()) {
                    serverPlayer.m_36327_().m_6836_(entry.getKey().intValue(), VanillaSync.deserializeAndCreatePlaceholderIfNeeded(entry.getValue()));
                }
                String string = rs2.getString("effects");
                if (string.length() > 2) {
                    serverPlayer.m_21219_();
                    Map<Integer, String> map = LocalJsonUtil.StringToEntryMap(string);
                    for (Map.Entry<Integer, String> entry : map.entrySet()) {
                        CompoundTag effectTag = NbtUtils.m_178024_((String)VanillaSync.deserializeString(entry.getValue()));
                        MobEffectInstance mobEffectInstance = MobEffectInstance.m_19560_((CompoundTag)effectTag);
                        if (mobEffectInstance == null) continue;
                        serverPlayer.m_7292_(mobEffectInstance);
                    }
                }
            }
            serverPlayer.m_20049_("player_synced");
            rs2.close();
        }
        catch (Exception e) {
            PlayerSync.LOGGER.error("Internal Exception detected!", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerConnect(PlayerNegotiationEvent event) {
        executorService.submit(() -> {
            try {
                VanillaSync.doPlayerConnect(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        executorService.submit(() -> {
            try {
                VanillaSync.doPlayerJoin(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static ItemStack deserializeAndCreatePlaceholderIfNeeded(String serializedNbt) throws CommandSyntaxException {
        String placeholderItemTitleOverride;
        if (serializedNbt == null || serializedNbt.isEmpty() || serializedNbt.equals("B64:e30=")) {
            return ItemStack.f_41583_;
        }
        String nbtString = VanillaSync.deserializeString(serializedNbt);
        CompoundTag compoundTag = VanillaSync.snbtToFixedCompoundTag(nbtString);
        if (compoundTag == null || compoundTag.m_128456_() || !compoundTag.m_128425_("id", 8)) {
            return ItemStack.f_41583_;
        }
        ResourceLocation registryName = ResourceLocation.m_135820_((String)compoundTag.m_128461_("id"));
        if (registryName == null) {
            PlayerSync.LOGGER.warn("Failed to parse registry name from NBT: {}", (Object)nbtString);
            return ItemStack.f_41583_;
        }
        if (ForgeRegistries.ITEMS.containsKey(registryName)) {
            try {
                ItemStack restoredItem = ItemStack.m_41712_((CompoundTag)compoundTag);
                if (!restoredItem.m_41619_() || compoundTag.m_128456_() || registryName.equals((Object)ResourceLocation.parse((String)"air"))) {
                    return restoredItem;
                }
                PlayerSync.LOGGER.warn("ItemStack.of returned EMPTY for known item {} with NBT: {}. Creating placeholder as fallback.", (Object)registryName, (Object)nbtString);
            }
            catch (Exception e) {
                PlayerSync.LOGGER.error("Error creating ItemStack for known item {} with NBT: {}. Creating placeholder as fallback.", new Object[]{registryName, nbtString, e});
            }
        }
        PlayerSync.LOGGER.debug("Item {} not found in registry. Creating placeholder.", (Object)registryName);
        ItemStack placeholder = new ItemStack((ItemLike)Items.f_42516_);
        CompoundTag placeholderNbt = placeholder.m_41784_();
        placeholderNbt.m_128359_("playersync:original_item_nbt", serializedNbt);
        placeholderNbt.m_128359_("playersync:original_item_id", registryName.toString());
        placeholderNbt.m_128362_("playersync:unique_id", UUID.randomUUID());
        CompoundTag displayTag = placeholderNbt.m_128469_("display");
        if (!placeholderNbt.m_128441_("display")) {
            placeholderNbt.m_128365_("display", (Tag)displayTag);
        }
        displayTag.m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)((placeholderItemTitleOverride = (String)JdbcConfig.ITEM_PLACEHOLDER_TITLE_OVERRIDE.get()) != null && !placeholderItemTitleOverride.isBlank() ? placeholderItemTitleOverride : Component.m_237115_((String)"playersync.item_placeholder_title").getString())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131155_(Boolean.valueOf(true)))));
        ListTag loreList = new ListTag();
        Object placeholderItemDetails = registryName.toString();
        PlayerSync.LOGGER.warn("Item {}: {}", (Object)registryName, (Object)compoundTag);
        int placeholderItemAmount = compoundTag.m_128451_("Count");
        if (placeholderItemAmount > 1) {
            placeholderItemDetails = placeholderItemAmount + "x " + (String)placeholderItemDetails;
        }
        loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)placeholderItemDetails).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false))))));
        loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)""))));
        String placeholderItemDescriptionOverride = (String)JdbcConfig.ITEM_PLACEHOLDER_DESCRIPTION_OVERRIDE.get();
        String placeholderItemDescriptionLines = placeholderItemDescriptionOverride != null && !placeholderItemDescriptionOverride.isBlank() ? placeholderItemDescriptionOverride : Component.m_237115_((String)"playersync.item_placeholder_description").getString();
        for (String descriptionLine : placeholderItemDescriptionLines.split("\n")) {
            loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)descriptionLine).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)))));
        }
        displayTag.m_128365_("Lore", (Tag)loreList);
        return placeholder;
    }

    public static CompoundTag snbtToFixedCompoundTag(String nbtString) throws CommandSyntaxException {
        CompoundTag parsedTag = TagParser.m_129359_((String)nbtString);
        int currentDataVersion = SharedConstants.m_183709_().m_183476_().m_193006_();
        int snbtDataVersion = NbtUtils.m_264487_((CompoundTag)parsedTag, (int)500);
        Dynamic dynamicTagInput = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)parsedTag);
        Dynamic updatedDynamicTag = DataFixers.m_14512_().update(References.f_16782_, dynamicTagInput, snbtDataVersion, currentDataVersion);
        return (CompoundTag)updatedDynamicTag.getValue();
    }

    public static String deserializeString(String encoded) {
        if (encoded.startsWith("B64:")) {
            String base64 = encoded.substring(4);
            try {
                return new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException ex) {
                PlayerSync.LOGGER.error("Base64 decoding failed for data: " + encoded, (Throwable)ex);
            }
        }
        return encoded.replace("|", ",").replace("^", "\"").replace("<", "{").replace(">", "}").replace("~", "'");
    }

    public static String serialize(String object) {
        if (((Boolean)JdbcConfig.USE_LEGACY_SERIALIZATION.get()).booleanValue()) {
            return object.replace(",", "|").replace("\"", "^").replace("{", "<").replace("}", ">").replace("'", "~");
        }
        return "B64:" + Base64.getEncoder().encodeToString(object.getBytes(StandardCharsets.UTF_8));
    }

    public static void doPlayerSaveToFile(PlayerEvent.SaveToFile event) throws SQLException, IOException {
        JDBCsetUp.executeUpdate("UPDATE server_info SET last_update=" + System.currentTimeMillis() + " WHERE id=" + String.valueOf(JdbcConfig.SERVER_ID.get()), new Object[0]);
        if (!event.getEntity().m_19880_().contains("player_synced")) {
            return;
        }
        VanillaSync.store(event.getEntity(), false);
    }

    @SubscribeEvent
    public static void onPlayerSaveToFile(PlayerEvent.SaveToFile event) {
        executorService.submit(() -> {
            try {
                VanillaSync.doPlayerSaveToFile(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void onServerShutdown(ServerStoppedEvent event) throws SQLException {
        JDBCsetUp.executeUpdate("UPDATE server_info SET enable= '0' WHERE id=" + String.valueOf(JdbcConfig.SERVER_ID.get()), new Object[0]);
    }

    public static void doPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) throws SQLException, IOException {
        String player_uuid = event.getEntity().m_20148_().toString();
        JDBCsetUp.executeUpdate("UPDATE player_data SET online= '0' WHERE uuid='" + player_uuid + "'", new Object[0]);
        VanillaSync.store(event.getEntity(), false);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) throws SQLException {
        ModsSupport modsSupport = new ModsSupport();
        modsSupport.onPlayerLeave(event.getEntity());
        executorService.submit(() -> {
            try {
                VanillaSync.doPlayerLogout(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static String getNbtForStorage(ItemStack itemStack) {
        if (itemStack.m_150930_(Items.f_42516_) && itemStack.m_41782_() && itemStack.m_41783_().m_128425_("playersync:original_item_nbt", 8)) {
            return itemStack.m_41783_().m_128461_("playersync:original_item_nbt");
        }
        return VanillaSync.serialize(VanillaSync.serializeNBT(itemStack).toString());
    }

    public static CompoundTag serializeNBT(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return new CompoundTag();
        }
        CompoundTag compoundTag = new CompoundTag();
        itemStack.m_41739_(compoundTag);
        NbtUtils.m_264171_((CompoundTag)compoundTag);
        return compoundTag;
    }

    public static void store(Player player, boolean init) throws SQLException, IOException {
        String player_uuid = player.m_20148_().toString();
        PlayerSync.LOGGER.info("Storing data for player " + player_uuid + " (init=" + init + ")");
        int XP = VanillaSync.getTotalExperience(player);
        int score = player.m_36344_();
        int food_level = player.m_36324_().m_38702_();
        int health = (int)player.m_21223_();
        String left_hand = VanillaSync.getNbtForStorage(player.m_21120_(InteractionHand.OFF_HAND));
        String cursors = VanillaSync.getNbtForStorage(player.f_36096_.m_142621_());
        HashMap<Integer, String> equipment = new HashMap<Integer, String>();
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35975_.get(i);
            equipment.put(i, VanillaSync.getNbtForStorage(itemStack));
        }
        Inventory inventory = player.m_150109_();
        HashMap<Integer, String> inventoryMap = new HashMap<Integer, String>();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            inventoryMap.put(i, VanillaSync.getNbtForStorage((ItemStack)inventory.f_35974_.get(i)));
        }
        HashMap<Integer, String> ender_chest = new HashMap<Integer, String>();
        for (int i = 0; i < player.m_36327_().m_6643_(); ++i) {
            ender_chest.put(i, VanillaSync.getNbtForStorage(player.m_36327_().m_8020_(i)));
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            ModsSupport.storeSophisticatedBackpacks(player);
        }
        Map effects = player.m_21221_();
        HashMap<Integer, String> effectMap = new HashMap<Integer, String>();
        for (Map.Entry entry : effects.entrySet()) {
            CompoundTag effectTag = ((MobEffectInstance)entry.getValue()).m_19555_(new CompoundTag());
            effectMap.put(MobEffect.m_19459_((MobEffect)((MobEffect)entry.getKey())), VanillaSync.serialize(effectTag.toString()));
        }
        File advancements = null;
        byte[] advancementBytes = new byte[]{};
        if (((Boolean)JdbcConfig.SYNC_ADVANCEMENTS.get()).booleanValue()) {
            File gameDir = Objects.requireNonNull(player.m_20194_()).m_6237_();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && server.m_6982_()) {
                PlayerSync.LOGGER.trace("Reading dedicated server advancements");
                advancements = new File(gameDir, VanillaSync.getSyncWorldForServer() + "/advancements/" + player_uuid + ".json");
            } else {
                PlayerSync.LOGGER.debug("Reading non-dedicated server advancements");
                File[] files = VanillaSync.scanAdvancementsFile(player_uuid, gameDir);
                long latestModifiedDate = 0L;
                for (File file : files) {
                    if (file == null || file.lastModified() <= latestModifiedDate) continue;
                    latestModifiedDate = file.lastModified();
                    advancements = file;
                }
            }
            if (!advancements.exists()) {
                PlayerSync.LOGGER.warn("Advancements file for " + player_uuid + " does not exist (yet).");
            }
            if (advancements != null && advancements.exists()) {
                PlayerSync.LOGGER.debug("Storing advancements for " + player_uuid + " from " + String.valueOf(advancements.toPath()));
                advancementBytes = Files.readAllBytes(advancements.toPath());
            } else {
                PlayerSync.LOGGER.error("Unable to save advancements for player " + player_uuid);
            }
        }
        String json = new String(advancementBytes, StandardCharsets.UTF_8);
        PlayerSync.LOGGER.trace("Storing advancements for player " + player_uuid + ": " + json);
        if (init) {
            JDBCsetUp.executeUpdate("INSERT INTO player_data (uuid,armor,inventory,enderchest,advancements,effects,xp,food_level,health,score,left_hand,cursors,online) VALUES ('" + player_uuid + "','" + String.valueOf(equipment) + "','" + String.valueOf(inventoryMap) + "','" + String.valueOf(ender_chest) + "','" + String.valueOf(advancements) + "','" + String.valueOf(effectMap) + "','" + XP + "','" + food_level + "','" + health + "','" + score + "','" + left_hand + "','" + cursors + "',online=true)", new Object[0]);
        } else {
            JDBCsetUp.executeUpdate("UPDATE player_data SET inventory = '" + String.valueOf(inventoryMap) + "',armor='" + String.valueOf(equipment) + "' ,xp='" + XP + "',effects='" + String.valueOf(effectMap) + "',enderchest='" + String.valueOf(ender_chest) + "',score='" + score + "',food_level='" + food_level + "',health='" + health + "',advancements='" + json + "',left_hand='" + left_hand + "',cursors='" + cursors + "' WHERE uuid = '" + player_uuid + "'", new Object[0]);
        }
    }

    private static String getSyncWorldForServer() {
        if (!((List)JdbcConfig.SYNC_WORLD.get()).isEmpty()) {
            PlayerSync.LOGGER.warn("Using configuration 'sync_world' on servers is deprecated. Please leave the array empty. Falling back to first entry.");
            return (String)((List)JdbcConfig.SYNC_WORLD.get()).get(0);
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            PlayerSync.LOGGER.error("Unable to get current server. Assuming default level-name 'world'.");
            return "world";
        }
        WorldData worldData = server.m_129910_();
        String levelName = worldData.m_5462_();
        PlayerSync.LOGGER.debug("Using server level-name: " + levelName);
        return levelName;
    }

    private static File[] scanAdvancementsFile(String player_uuid, File gameDir) {
        File[] files = new File[((List)JdbcConfig.SYNC_WORLD.get()).size()];
        for (int i = 0; i < ((List)JdbcConfig.SYNC_WORLD.get()).size(); ++i) {
            File advanceFile = new File(gameDir, "saves/" + (String)((List)JdbcConfig.SYNC_WORLD.get()).get(i) + "/advancements/" + player_uuid + ".json");
            if (!advanceFile.exists()) continue;
            files[i] = advanceFile;
        }
        return files;
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.LevelTickEvent event) throws SQLException {
        if (++tick == 1800) {
            tick = 0;
            long current = System.currentTimeMillis();
            JDBCsetUp.executeUpdate("UPDATE server_info SET last_update =" + current + " WHERE id= " + String.valueOf(JdbcConfig.SERVER_ID.get()), new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++autoSaveTickCounter >= 1200) {
            autoSaveTickCounter = 0;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    executorService.submit(() -> {
                        try {
                            VanillaSync.store((Player)player, false);
                        }
                        catch (Exception e) {
                            PlayerSync.LOGGER.error("Error auto-saving player " + String.valueOf(player.m_20148_()), (Throwable)e);
                        }
                    });
                    executorService.submit(() -> {
                        try {
                            new ModsSupport().StoreCurios((Player)player, false);
                        }
                        catch (SQLException e) {
                            PlayerSync.LOGGER.error("Error auto-saving Curios data for player " + String.valueOf(player.m_20148_()), (Throwable)e);
                        }
                    });
                }
            }
        }
    }

    private static void setXpForPlayer(ServerPlayer serverPlayer, int databaseXp) {
        int xpForLevel;
        serverPlayer.f_36079_ = databaseXp;
        serverPlayer.f_36078_ = 0;
        serverPlayer.f_36080_ = 0.0f;
        while (databaseXp >= (xpForLevel = serverPlayer.m_36323_())) {
            databaseXp -= xpForLevel;
            ++serverPlayer.f_36078_;
        }
        serverPlayer.f_36080_ = serverPlayer.f_36078_ > 0 ? (float)databaseXp / (float)serverPlayer.m_36323_() : 0.0f;
        PlayerSync.LOGGER.debug("Giving player " + serverPlayer.f_36078_ + " levels and " + serverPlayer.f_36080_ * 100.0f + "% experience progress, calculated from " + serverPlayer.f_36079_ + " XP.");
    }

    private static int getTotalExperience(Player player) {
        int level = player.f_36078_;
        int totalXp = 0;
        totalXp = level > 30 ? (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0) : (level > 15 ? (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0) : level * level + 6 * level);
        PlayerSync.LOGGER.debug("Experience calcuation for " + player.f_36078_ + " levels and " + player.f_36080_ * 100.0f + "% experience progress yields " + (totalXp += Math.round((float)player.m_36323_() * player.f_36080_)) + " XP.");
        return totalXp;
    }
}

