/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync.sync.chat;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vip.fubuki.playersync.PlayerSync;
import vip.fubuki.playersync.config.JdbcConfig;

public class ChatSyncClient {
    static PlayerList playerList;
    static Socket clientSocket;
    static PrintWriter out;
    private static volatile boolean running;
    private static final int RECONNECT_DELAY = 5000;
    private static final int MAX_RECONNECT_ATTEMPTS = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int reconnectAttempts = 0;
        while (running && reconnectAttempts < 10) {
            try {
                String serverMessage;
                PlayerSync.LOGGER.info("Connecting to chat server {}:{}", JdbcConfig.CHAT_SERVER_IP.get(), JdbcConfig.CHAT_SERVER_PORT.get());
                clientSocket = new Socket();
                clientSocket.setReuseAddress(true);
                clientSocket.setKeepAlive(true);
                clientSocket.setTcpNoDelay(true);
                clientSocket.connect(new InetSocketAddress((String)JdbcConfig.CHAT_SERVER_IP.get(), (int)((Integer)JdbcConfig.CHAT_SERVER_PORT.get())), 15000);
                clientSocket.setSoTimeout(0);
                out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream())), true);
                PlayerSync.LOGGER.info("Successfully connected to chat server");
                reconnectAttempts = 0;
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                while (running && (serverMessage = in.readLine()) != null) {
                    Component textComponents = Component.m_130674_((String)serverMessage);
                    if (playerList != null) {
                        playerList.m_7873_().execute(() -> playerList.m_240416_(textComponents, false));
                        continue;
                    }
                    PlayerSync.LOGGER.info("Received message from chat server: " + serverMessage);
                }
            }
            catch (SocketTimeoutException e) {
                PlayerSync.LOGGER.warn("Chat server read timeout, reconnecting...");
            }
            catch (ConnectException e) {
                PlayerSync.LOGGER.warn("Cannot connect to chat server: {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                PlayerSync.LOGGER.error("Chat client connection error: {}", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
            if (!running || reconnectAttempts >= 10) continue;
            PlayerSync.LOGGER.warn("Attempting to reconnect to chat server ({}/{})", (Object)(++reconnectAttempts), (Object)10);
            try {
                long delay = Math.min(5000L * (long)Math.pow(2.0, reconnectAttempts - 1), 60000L);
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void closeConnection() {
        try {
            if (out != null) {
                out.close();
                out = null;
            }
            if (clientSocket != null && !clientSocket.isClosed()) {
                clientSocket.close();
                clientSocket = null;
            }
        }
        catch (IOException e) {
            PlayerSync.LOGGER.error("Error closing connection: {}", (Object)e.getMessage());
        }
    }

    public void shutdown() {
        running = false;
        this.closeConnection();
    }

    @SubscribeEvent
    public static void onPlayerChat(ServerChatEvent event) {
        String message = "<" + event.getUsername() + "> " + event.getMessage().getString();
        if (out != null) {
            out.println(message);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        playerList = Objects.requireNonNull(event.getEntity().m_20194_()).m_6846_();
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        playerList = Objects.requireNonNull(event.getEntity().m_20194_()).m_6846_();
    }

    static {
        running = true;
    }
}

