/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync.sync.chat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import vip.fubuki.playersync.PlayerSync;
import vip.fubuki.playersync.config.JdbcConfig;

public class ChatSyncServer {
    static ServerSocket serverSocket;
    static final Set<Socket> SocketList;
    static final ExecutorService executorService;
    private volatile boolean running = true;

    public void run() throws IOException {
        try {
            serverSocket = new ServerSocket((Integer)JdbcConfig.CHAT_SERVER_PORT.get());
            serverSocket.setReuseAddress(true);
            PlayerSync.LOGGER.info("Chat server started successfully on port {}", JdbcConfig.CHAT_SERVER_PORT.get());
            while (this.running && !Thread.currentThread().isInterrupted()) {
                try {
                    Socket newSocket = serverSocket.accept();
                    newSocket.setSoTimeout(0);
                    SocketList.add(newSocket);
                    executorService.submit(() -> this.handleClient(newSocket));
                    PlayerSync.LOGGER.info("New client connected, total clients: {}", (Object)SocketList.size());
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    PlayerSync.LOGGER.error("Error accepting client connection: {}", (Object)e.getMessage());
                }
            }
        }
        finally {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(Socket socket) {
        String clientInfo = String.valueOf(socket.getInetAddress()) + ":" + socket.getPort();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
            String message;
            while (this.running && (message = reader.readLine()) != null) {
                this.broadcastMessage(socket, message);
            }
        }
        catch (SocketTimeoutException e) {
            PlayerSync.LOGGER.warn("Client {} timeout", (Object)clientInfo);
        }
        catch (IOException e) {
            PlayerSync.LOGGER.error("Error handling client {}: {}", (Object)clientInfo, (Object)e.getMessage());
        }
        finally {
            SocketList.remove(socket);
            try {
                if (!socket.isClosed()) {
                    socket.close();
                }
            }
            catch (IOException e) {
                PlayerSync.LOGGER.error("Error closing client socket: {}", (Object)e.getMessage());
            }
            PlayerSync.LOGGER.info("Client disconnected, remaining clients: {}", (Object)SocketList.size());
        }
    }

    private void broadcastMessage(Socket sender, String message) {
        Iterator<Socket> iterator = SocketList.iterator();
        while (iterator.hasNext()) {
            Socket socket = iterator.next();
            if (socket.equals(sender) || socket.isClosed()) continue;
            try {
                PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
                writer.println(message);
            }
            catch (IOException e) {
                PlayerSync.LOGGER.error("Error broadcasting to client, removing: {}", (Object)e.getMessage());
                iterator.remove();
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void shutdown() {
        this.running = false;
        try {
            if (serverSocket != null && !serverSocket.isClosed()) {
                serverSocket.close();
            }
        }
        catch (IOException e) {
            PlayerSync.LOGGER.error("Error closing server socket: {}", (Object)e.getMessage());
        }
        for (Socket socket : SocketList) {
            try {
                if (socket.isClosed()) continue;
                socket.close();
            }
            catch (IOException iOException) {}
        }
        SocketList.clear();
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        SocketList = ConcurrentHashMap.newKeySet();
        executorService = Executors.newCachedThreadPool();
    }
}

