/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.playersync.util;

import com.mojang.logging.LogUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import vip.fubuki.playersync.config.JdbcConfig;

public class JDBCsetUp {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static Connection getConnection(boolean selectDatabase) throws SQLException {
        String dbName = (String)JdbcConfig.DATABASE_NAME.get();
        String url = "jdbc:mysql://" + (String)JdbcConfig.HOST.get() + ":" + String.valueOf(JdbcConfig.PORT.get());
        if (selectDatabase && dbName != null && !dbName.isEmpty()) {
            url = url + "/" + dbName;
        }
        url = url + "?useUnicode=true&characterEncoding=utf-8&useSSL=" + String.valueOf(JdbcConfig.USE_SSL.get()) + "&serverTimezone=UTC&allowPublicKeyRetrieval=true";
        Connection conn = DriverManager.getConnection(url, (String)JdbcConfig.USERNAME.get(), (String)JdbcConfig.PASSWORD.get());
        if (selectDatabase && dbName != null && !dbName.isEmpty()) {
            try (Statement st = conn.createStatement();){
                st.execute("USE " + dbName);
            }
        }
        return conn;
    }

    public static Connection getConnection() throws SQLException {
        return JDBCsetUp.getConnection(true);
    }

    public static QueryResult executeQuery(String sqlFormatString, Object ... args) throws SQLException {
        String sql = String.format(sqlFormatString, args);
        LOGGER.trace(sql);
        Connection connection = JDBCsetUp.getConnection();
        PreparedStatement queryStatement = connection.prepareStatement(sql);
        ResultSet resultSet = queryStatement.executeQuery();
        return new QueryResult(connection, queryStatement, resultSet);
    }

    private static void executeUpdate(boolean selectDatabase, String sqlFormatString, Object ... args) throws SQLException {
        String sql = String.format(sqlFormatString, args);
        LOGGER.trace(sql);
        try (Connection connection = JDBCsetUp.getConnection(selectDatabase);
             PreparedStatement updateStatement = connection.prepareStatement(sql);){
            updateStatement.executeUpdate();
        }
    }

    public static void executeUpdate(String sqlFormatString, Object ... args) throws SQLException {
        JDBCsetUp.executeUpdate(true, sqlFormatString, args);
    }

    public static void executeUpdateWithoutDatabase(String sqlFormatString, Object ... args) throws SQLException {
        JDBCsetUp.executeUpdate(false, sqlFormatString, args);
    }

    public static void update(String sql, String ... argument) throws SQLException {
        LOGGER.trace(sql);
        try (Connection connection = JDBCsetUp.getConnection();){
            PreparedStatement updateStatement = connection.prepareStatement(sql);
            for (int i = 0; i < argument.length; ++i) {
                updateStatement.setString(i + 1, argument[i]);
            }
            updateStatement.executeUpdate();
        }
    }

    public record QueryResult(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) implements AutoCloseable
    {
        @Override
        public void close() {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Error closing ResultSet", (Throwable)e);
                }
            }
            if (this.preparedStatement != null) {
                try {
                    this.preparedStatement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Error closing PreparedStatement", (Throwable)e);
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Error closing Connection", (Throwable)e);
                }
            }
        }
    }
}

