/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class ModDamageListeners {
    public static final Map<EntityType<?>, EntityProvider<?>> REGISTERED = new HashMap();

    public static void init() {
        ModDamageListeners.register(EntityType.f_20555_, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedChickenFeathers) {
                for (int i = 0; i < 10; ++i) {
                    level.m_7106_((ParticleOptions)ModParticles.CHICKEN_FEATHER.get(), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.f_20508_, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedParrotFeathers) {
                SimpleParticleType particle = switch (entity.m_28554_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Parrot.Variant.BLUE -> ModParticles.BLUE_PARROT_FEATHER.get();
                    case Parrot.Variant.GRAY -> ModParticles.GRAY_PARROT_FEATHER.get();
                    case Parrot.Variant.GREEN -> ModParticles.GREEN_PARROT_FEATHER.get();
                    case Parrot.Variant.RED_BLUE -> ModParticles.RED_BLUE_PARROT_FEATHER.get();
                    case Parrot.Variant.YELLOW_BLUE -> ModParticles.YELLOW_BLUE_PARROT_FEATHER.get();
                };
                for (int i = 0; i < 5; ++i) {
                    level.m_7106_((ParticleOptions)particle, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.f_20528_, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedSnowGolemSnowflakes) {
                for (int i = 0; i < 20; ++i) {
                    level.m_7106_((ParticleOptions)ModParticles.SNOW.get(), entity.m_20185_(), entity.m_20227_((double)random.m_188501_()), entity.m_20189_(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.f_20520_, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedSheepFluff) {
                ParticleSpawnUtil.spawnSheepFluff(entity, random.m_188503_(3));
            }
        });
        ModDamageListeners.register(EntityType.f_20526_, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedSlimeSlime) {
                boolean replaceSlimeSquishParticles = ModConfigs.ENTITIES.replaceSlimeSquishParticles;
                BlockParticleOption options = replaceSlimeSquishParticles ? new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42518_.m_7968_());
                double maxSpeed = replaceSlimeSquishParticles ? 0.5 : 0.15;
                for (int i = 0; i < 10 * entity.m_33632_(); ++i) {
                    int xSign = MathUtil.nextSign(random);
                    int zSign = MathUtil.nextSign(random);
                    level.m_7106_((ParticleOptions)options, entity.m_20165_(MathUtil.nextDouble(random, 0.5) * (double)xSign), entity.m_20187_(), entity.m_20246_(MathUtil.nextDouble(random, 0.5) * (double)zSign), MathUtil.nextDouble(random, maxSpeed) * (double)xSign, 0.0, MathUtil.nextDouble(random, maxSpeed) * (double)zSign);
                }
            }
        });
    }

    private static <T extends Entity> void register(EntityType<T> type, EntityProvider<T> provider) {
        REGISTERED.put(type, provider);
    }
}

