/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.block;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractCauldronBlock.class})
public class AbstractCauldronBlockMixin {
    @ModifyReturnValue(method={"use"}, at={@At(value="RETURN")})
    private InteractionResult spawnInteractionParticles(InteractionResult result, @Local(argsOnly=true) BlockState state, @Local(argsOnly=true) Level level, @Local(argsOnly=true) BlockPos pos, @Local CauldronInteraction interaction) {
        if (level.f_46443_ && result == InteractionResult.SUCCESS) {
            RandomSource random = level.m_213780_();
            if (ModConfigs.BLOCKS.cauldronUseParticles || ModConfigs.BLOCKS.cauldronCleanItemSounds) {
                TickerManager.schedule(2, () -> {
                    if (ModConfigs.BLOCKS.cauldronUseParticles) {
                        if (level.m_6425_(pos.m_7494_()).m_76186_() >= 5) {
                            return;
                        }
                        BlockState newState = level.m_8055_(pos);
                        boolean isEmpty = newState.m_60713_(Blocks.f_50256_);
                        double fluidHeight = Util.getCauldronFillHeight(isEmpty ? state : newState);
                        ParticleOptions particle = Util.getCauldronParticle(isEmpty ? state : newState);
                        if (fluidHeight > 0.0 && particle != null) {
                            for (int i = 0; i < 16; ++i) {
                                int xSign = MathUtil.nextSign(random);
                                int zSign = MathUtil.nextSign(random);
                                level.m_7106_(particle, (double)pos.m_123341_() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, (double)pos.m_123342_() + fluidHeight, (double)pos.m_123343_() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, MathUtil.nextDouble(random, 0.15f) * (double)xSign, MathUtil.nextDouble(random, 0.35f), MathUtil.nextDouble(random, 0.15f) * (double)zSign);
                            }
                        }
                    }
                    if (ModConfigs.BLOCKS.cauldronCleanItemSounds && (interaction.equals(CauldronInteraction.f_175615_) || interaction.equals(CauldronInteraction.f_175614_) || interaction.equals(CauldronInteraction.f_175613_))) {
                        Util.playClientSound(pos, ModSounds.CAULDRON_CLEAN_ITEM.get(), SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
                    }
                });
            }
        }
        return result;
    }
}

