/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.ColorParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AreaEffectCloud.class})
public abstract class AreaEffectCloudMixin {
    @Unique
    private int subtleEffects$waitedTime;
    @Unique
    private final AreaEffectCloud subtleEffects$me = (AreaEffectCloud)this;
    @Shadow
    @Final
    private static EntityDataAccessor<ParticleOptions> f_19700_;

    @Shadow
    public abstract boolean m_19747_();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (this.subtleEffects$me.m_9236_().m_5776_() && this.m_19747_() && this.subtleEffects$waitedTime < 10) {
            ++this.subtleEffects$waitedTime;
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void cancelVanillaParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
    }

    @WrapOperation(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/core/particles/ParticleOptions;getType()Lnet/minecraft/core/particles/ParticleType;"), to=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/core/particles/ParticleOptions;getType()Lnet/minecraft/core/particles/ParticleType;")})
    private ParticleType<?> replaceParticles(ParticleOptions options, Operation<ParticleType<?>> original, @Local(ordinal=1) float radius) {
        Level level = this.subtleEffects$me.m_9236_();
        RandomSource random = level.m_213780_();
        boolean isWaiting = this.subtleEffects$me.m_19747_();
        float f2 = random.m_188501_() * ((float)Math.PI * 2);
        float f3 = Mth.m_14116_((float)random.m_188501_()) * radius;
        double x = this.subtleEffects$me.m_20185_() + (double)(Mth.m_14089_((float)f2) * f3);
        double y = this.subtleEffects$me.m_20186_();
        double z = this.subtleEffects$me.m_20189_() + (double)(Mth.m_14031_((float)f2) * f3);
        if (options.m_6012_() == ParticleTypes.f_123811_) {
            int color = this.subtleEffects$me.m_19744_();
            double red = (float)(color >> 16 & 0xFF) / 255.0f;
            double green = (float)(color >> 8 & 0xFF) / 255.0f;
            double blue = (float)(color & 0xFF) / 255.0f;
            if (isWaiting && random.m_188499_()) {
                this.subtleEffects$replaceWaitingParticles(level, options, x, y, z, -1.0, -1.0, -1.0);
            } else {
                this.subtleEffects$replaceEffectParticles(level, options, x, y, z, red, green, blue);
            }
        } else if (isWaiting) {
            this.subtleEffects$replaceNonEffectWaitingParticles(level, options, x, y, z, 0.0, 0.0, 0.0);
        } else {
            this.subtleEffects$replaceNonEffectParticles(level, options, x, y, z, 0.0, 0.0, 0.0);
        }
        return null;
    }

    @Unique
    private void subtleEffects$replaceWaitingParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (ModConfigs.ITEMS.lingeringPotionClouds) {
            if (this.subtleEffects$waitedTime < 10) {
                return;
            }
            options = new ColorParticleOptions(ModParticles.POTION_POOF_CLOUD.get(), new Vector3f(-1.0f, -1.0f, -1.0f));
        }
        level.m_7107_(options, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Unique
    private void subtleEffects$replaceEffectParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (ModConfigs.ITEMS.lingeringPotionClouds && this.subtleEffects$spawnParticles(level, (float)xSpeed, (float)ySpeed, (float)zSpeed, x, y, z, 20, 4)) {
            return;
        }
        level.m_7107_(options, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Unique
    private void subtleEffects$replaceNonEffectWaitingParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (ModConfigs.ITEMS.lingeringPotionClouds && CompatHelper.IS_PARTICLE_EFFECTS_LOADED.get().booleanValue()) {
            if (this.subtleEffects$waitedTime < 10) {
                return;
            }
            if (level.m_213780_().m_188499_() && AreaEffectCloudMixin.subtleEffects$isParticleEffectsParticle(options)) {
                options = new ColorParticleOptions(ModParticles.POTION_POOF_CLOUD.get(), new Vector3f(-1.0f, -1.0f, -1.0f));
            }
        }
        level.m_7107_(options, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Unique
    private void subtleEffects$replaceNonEffectParticles(Level level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        float blue;
        float green;
        int color;
        float red;
        ParticleOptions particleOptions;
        RandomSource random;
        if (ModConfigs.ENTITIES.dragonsBreathClouds && options.m_6012_() == ParticleTypes.f_123799_ && this.subtleEffects$spawnParticles(level, Mth.m_216267_((RandomSource)(random = level.m_213780_()), (float)0.7176471f, (float)0.8745098f), 0.0f, Mth.m_216267_((RandomSource)random, (float)0.8235294f, (float)0.9764706f), x, y, z, 35, 15)) {
            return;
        }
        if (ModConfigs.ITEMS.lingeringPotionClouds && CompatHelper.IS_PARTICLE_EFFECTS_LOADED.get().booleanValue() && AreaEffectCloudMixin.subtleEffects$isParticleEffectsParticle(options) && (particleOptions = (ParticleOptions)this.subtleEffects$me.m_20088_().m_135370_(f_19700_)).m_6012_() == ParticleTypes.f_123811_ && this.subtleEffects$spawnParticles(level, red = (float)((color = this.subtleEffects$me.m_19744_()) >> 16 & 0xFF) / 255.0f, green = (float)(color >> 8 & 0xFF) / 255.0f, blue = (float)(color & 0xFF) / 255.0f, x, y, z, 20, 24)) {
            return;
        }
        level.m_7107_(options, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Unique
    private boolean subtleEffects$spawnParticles(Level level, float red, float green, float blue, double x, double y, double z, int density, int waitingDensity) {
        boolean isWaiting = this.m_19747_();
        if (isWaiting && this.subtleEffects$waitedTime < 10) {
            return true;
        }
        RandomSource random = level.m_213780_();
        if (random.m_188503_(isWaiting ? waitingDensity : density) == 0) {
            if (isWaiting) {
                level.m_7106_((ParticleOptions)new ColorParticleOptions(ModParticles.POTION_POOF_CLOUD.get(), new Vector3f(red, green, blue)), x, y, z, 0.0, 0.0, 0.0);
            } else {
                if (this.subtleEffects$me.f_19797_ <= 5) {
                    return true;
                }
                level.m_7107_((ParticleOptions)new ColorParticleOptions(ModParticles.POTION_CLOUD.get(), new Vector3f(red, green, blue)), x, this.subtleEffects$me.m_20186_() + random.m_188500_() / 10.0, z, 0.0, 0.0, 0.0);
            }
        }
        return !isWaiting && random.m_188503_(20) > 0;
    }

    @Unique
    private static boolean subtleEffects$isParticleEffectsParticle(ParticleOptions options) {
        ResourceLocation id = BuiltInRegistries.f_257034_.m_7981_((Object)options.m_6012_());
        return id != null && id.m_135827_().equals("particle-effects");
    }
}

