/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.util.DripParticleAccessor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SplashDropletParticle
extends DripParticle.FallAndLandParticle
implements DripParticleAccessor {
    private final boolean glowing;

    protected SplashDropletParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float scale, SpriteSet sprites, boolean glowing, Fluid fluid, SimpleParticleType landParticle, boolean isSilent) {
        super(level, x, y, z, fluid, (ParticleOptions)landParticle);
        this.glowing = glowing;
        this.m_172260_(xSpeed, ySpeed, zSpeed);
        this.m_108335_(sprites);
        this.m_6569_(scale * 1.5f);
        this.f_107226_ = 0.06f;
        if (isSilent) {
            this.subtleEffects$setSilent();
        }
    }

    public int m_6355_(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.m_6355_(partialTick);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107213_ == this.f_107210_) {
            this.m_107274_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<SplashDropletParticleOptions>
    {
        public Particle createParticle(SplashDropletParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashDropletParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.scale(), this.sprites, true, (Fluid)Fluids.f_76195_, ParticleTypes.f_123802_, options.isSilent());
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SplashDropletParticleOptions>
    {
        public Particle createParticle(SplashDropletParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashDropletParticle particle = new SplashDropletParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.scale(), this.sprites, false, (Fluid)Fluids.f_76193_, ParticleTypes.f_123769_, options.isSilent());
            int waterColor = ((Biome)level.m_204166_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_203334_()).m_47560_();
            float colorIntensity = options.colorIntensity();
            float whiteIntensity = 1.0f - colorIntensity;
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            particle.m_107253_(whiteIntensity + colorIntensity * red, whiteIntensity + colorIntensity * green, whiteIntensity + colorIntensity * blue);
            return particle;
        }
    }
}

