/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.platform.services;

import einstein.subtle_effects.networking.Packet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public interface NetworkHelper {
    public static final Map<Class<? extends Packet>, PacketData<? extends Packet>> PACKETS = new HashMap<Class<? extends Packet>, PacketData<? extends Packet>>();

    default public <T extends Packet> void registerToClient(ResourceLocation id, Class<T> clazz, Function<FriendlyByteBuf, T> decoder) {
        PACKETS.put(clazz, new PacketData<T>(id, Direction.TO_CLIENT, decoder, PacketData.ID++));
    }

    public <T extends Packet> boolean sendToServer(T var1);

    public <T extends Packet> boolean sendToClient(T var1, ServerPlayer var2);

    public <T extends Packet> void sendToClientsTracking(ServerLevel var1, BlockPos var2, T var3);

    public <T extends Packet> void sendToClientsTracking(@Nullable ServerPlayer var1, ServerLevel var2, BlockPos var3, T var4);

    public <T extends Packet> void sendToClientsTracking(@Nullable ServerPlayer var1, ServerLevel var2, BlockPos var3, T var4, @Nullable Consumer<ServerPlayer> var5);

    public record PacketData<T extends Packet>(ResourceLocation id, Direction direction, Function<FriendlyByteBuf, T> decoder, int rawId) {
        private static int ID;
    }

    public static enum Direction {
        TO_CLIENT,
        TO_SERVER;

    }
}

