/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.SereneSeasonsCompat;
import einstein.subtle_effects.configs.environment.FireflyConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.util.MathUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class FireflyManager {
    public static void tick(Level level, BlockPos pos, BlockState state, RandomSource random) {
        if (!ModConfigs.ENVIRONMENT.fireflies.firefliesEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91074_.f_19797_ < 200) {
            return;
        }
        Optional dimensionKey = level.m_204156_().m_203543_();
        if (dimensionKey.isEmpty() || ModConfigs.ENVIRONMENT.fireflies.dimensionBlocklist.contains((Object)((ResourceKey)dimensionKey.get()).m_135782_())) {
            return;
        }
        if (CompatHelper.IS_SERENE_SEANSONS_LOADED.get().booleanValue() && SereneSeasonsCompat.isColdSeason(level, ModConfigs.ENVIRONMENT.fireflies.ignoredSeasons)) {
            return;
        }
        Holder biome = level.m_204166_(pos);
        Optional biomeKey = biome.m_203543_();
        if (biomeKey.isEmpty()) {
            return;
        }
        ResourceLocation biomeId = ((ResourceKey)biomeKey.get()).m_135782_();
        if (!ModConfigs.ENVIRONMENT.fireflies.biomesBlocklist.contains((Object)biomeId)) {
            float time;
            boolean isHabitatBiome = ModConfigs.ENVIRONMENT.fireflies.habitatBiomes.contains((Object)biomeId);
            boolean isSpawnable = ModConfigs.ENVIRONMENT.fireflies.spawnableBlocks.contains((Object)state.m_60734_());
            if (!(isHabitatBiome || !ModConfigs.ENVIRONMENT.fireflies.onlyAllowInHabitatBiomes && isSpawnable)) {
                return;
            }
            boolean canSeeSky = level.m_45527_(pos);
            int surfaceLevel = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_();
            if (isHabitatBiome) {
                if (!canSeeSky && !isSpawnable) {
                    return;
                }
                if (canSeeSky && surfaceLevel + 10 < pos.m_123342_()) {
                    return;
                }
            }
            if (!(!((Biome)biome.m_203334_()).m_198906_(pos) && !ModConfigs.ENVIRONMENT.fireflies.biomesAllowlist.contains((Object)biomeId) || !((time = (float)level.m_46468_() % 24000.0f) > 13000.0f && time < 23000.0f) && level.m_45517_(LightLayer.SKY, pos) != 0 || level.m_45517_(LightLayer.BLOCK, pos) > 5 || level.m_46471_() && canSeeSky && surfaceLevel <= pos.m_123342_() || state.m_60838_((BlockGetter)level, pos) || !level.m_6425_(pos).m_76178_())) {
                if (FireflyManager.canSpawn(random, isHabitatBiome)) {
                    level.m_7106_((ParticleOptions)ModConfigs.ENVIRONMENT.fireflies.fireflyType.getParticle().get(), (double)pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), (double)pos.m_123342_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), (double)pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), 0.0, 0.0, 0.0);
                }
                if (((Float)ModConfigs.ENVIRONMENT.fireflies.fireflySoundVolume.get()).floatValue() > 0.0f && FireflyManager.canPlaySound(random, isHabitatBiome)) {
                    level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.FIREFLY_BUZZ.get(), SoundSource.AMBIENT, ((Float)ModConfigs.ENVIRONMENT.fireflies.fireflySoundVolume.get()).floatValue(), 1.0f, false);
                }
            }
        }
    }

    private static boolean canPlaySound(RandomSource random, boolean isHabitatBiome) {
        if (isHabitatBiome) {
            return random.m_188500_() < 1.0E-5 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.habitatBiomeDensity.get()).intValue();
        }
        return random.m_188500_() < 3.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.defaultDensity.get()).intValue();
    }

    private static boolean canSpawn(RandomSource random, boolean isHabitatBiome) {
        if (isHabitatBiome) {
            return random.m_188500_() < 5.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.habitatBiomeDensity.get()).intValue();
        }
        int spawnRate = ModConfigs.ENVIRONMENT.fireflies.fireflyType == FireflyConfigs.FireflyType.VANILLA ? 170 : 1;
        return random.m_188500_() < 0.008 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.defaultDensity.get()).intValue() * (double)spawnRate;
    }
}

