/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers.geyser;

import einstein.subtle_effects.particle.option.GeyserSpoutParticleOptions;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.Ticker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.geyser.GeyserType;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public abstract class GeyserTicker
extends BlockPosTicker {
    protected final GeyserType type;
    protected final int lifeTime;
    protected int age;

    public GeyserTicker(GeyserType type, Level level, BlockPos pos, RandomSource random) {
        super(level, random, pos);
        this.type = type;
        this.lifeTime = this.getTickDelay((Integer)type.activeTime.get());
        this.updateGeyserPositions(GeyserManager.ACTIVE_GEYSERS, list -> list.add(pos));
    }

    protected final void updateGeyserPositions(Map<GeyserType, List<BlockPos>> map, Consumer<List<BlockPos>> consumer) {
        if (!map.containsKey((Object)this.type)) {
            map.put(this.type, new ArrayList());
        }
        consumer.accept(map.get((Object)this.type));
    }

    public static void trySpawn(GeyserType type, Level level, BlockPos pos, RandomSource random) {
        if (!(GeyserManager.ACTIVE_GEYSERS.containsKey((Object)type) && GeyserManager.ACTIVE_GEYSERS.get((Object)type).contains(pos) || GeyserManager.INACTIVE_GEYSERS.containsKey((Object)type) && GeyserManager.INACTIVE_GEYSERS.get((Object)type).contains(pos) || !GeyserTicker.checkLocation(type, level, pos, type.height))) {
            TickerManager.add((Ticker)type.geyserTickerProvider.apply((Object)level, (Object)pos, (Object)random));
        }
    }

    public static boolean checkLocation(GeyserType type, Level level, BlockPos pos, int checkHeight) {
        BlockPos abovePos;
        if (GeyserTicker.isSpawnableBlock(type, level, pos, SupportType.CENTER) && GeyserTicker.canGeyserPassThrough(type, level, abovePos = pos.m_7494_())) {
            if (checkHeight > 0) {
                for (int i = 1; i < checkHeight; ++i) {
                    if (GeyserTicker.canGeyserPassThrough(type, level, abovePos.m_5484_(Direction.UP, i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean canGeyserPassThrough(GeyserType type, Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        return !state.m_60783_((BlockGetter)level, pos, Direction.DOWN) && !(state.m_60734_() instanceof BaseFireBlock) && (type.fluid != null ? fluidState.m_192917_(type.fluid) && fluidState.m_76170_() : fluidState.m_76178_());
    }

    public static boolean isSpawnableBlock(GeyserType type, Level level, BlockPos pos, SupportType supportType) {
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(pos);
        return type.spawnableBlocks.contains((Object)state.m_60734_()) && state.m_60659_((BlockGetter)level, pos, Direction.UP, supportType) || type.spawnableBlocks.contains((Object)fluidState.m_76188_().m_60734_());
    }

    @Override
    public void positionedTick() {
        ++this.age;
        if (this.age >= this.lifeTime) {
            this.remove();
            return;
        }
        if (Util.isChunkLoaded(this.level, this.pos.m_123341_(), this.pos.m_123343_()) && GeyserTicker.checkLocation(this.type, this.level, this.pos, 0)) {
            if (this.age == 1 && GeyserTicker.isSpawnableBlock(this.type, this.level, this.pos, SupportType.RIGID)) {
                this.level.m_7106_((ParticleOptions)new GeyserSpoutParticleOptions(this.type.ordinal(), this.lifeTime), (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.001, (double)this.pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
            this.geyserTick();
            return;
        }
        this.remove();
    }

    protected abstract void geyserTick();

    @Override
    public void remove() {
        super.remove();
        this.updateGeyserPositions(GeyserManager.ACTIVE_GEYSERS, list -> list.remove(this.pos));
        this.updateGeyserPositions(GeyserManager.INACTIVE_GEYSERS, list -> list.add(this.pos));
        TickerManager.schedule(this.getTickDelay((Integer)this.type.inactiveTime.get()), () -> this.updateGeyserPositions(GeyserManager.INACTIVE_GEYSERS, list -> list.remove(this.pos)));
    }

    private int getTickDelay(int max) {
        return max >= 300 ? Mth.m_216271_((RandomSource)this.random, (int)(max - 200), (int)max) : max;
    }
}

