/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModPackets;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModTickers;
import einstein.subtle_effects.tickers.TickerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModPackets.initClientHandlers();
        ModTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticles.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.player;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                TickerManager.clear();
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.isPaused() || level.tickRateManager().isFrozen()) {
            return;
        }
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        TickerManager.tickTickers(level);
        HAS_CLEARED = false;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.getInstance();
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(context -> {
            minecraft.particleEngine.clearParticles();
            SubtleEffectsClient.sendSystemMsg(minecraft, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
            return 1;
        });
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(context -> {
            TickerManager.clear();
            SubtleEffectsClient.sendSystemMsg(minecraft, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
            return 1;
        });
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static MutableComponent getMsgTranslation(String string) {
        return Component.translatable((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(Minecraft minecraft, Component component) {
        minecraft.gui.getChat().addMessage(component);
    }
}

