/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.configs.entities.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.BooleanParticleOptions;
import einstein.subtle_effects.tickers.DrowningTicker;
import einstein.subtle_effects.tickers.EntityFireTicker;
import einstein.subtle_effects.tickers.EntityWaterCauldronTicker;
import einstein.subtle_effects.tickers.FrostyBreathTicker;
import einstein.subtle_effects.tickers.HeartbeatTicker;
import einstein.subtle_effects.tickers.HumanoidPotionRingTicker;
import einstein.subtle_effects.tickers.IronGolemTicker;
import einstein.subtle_effects.tickers.ItemRarityTicker;
import einstein.subtle_effects.tickers.MinecartSparksTicker;
import einstein.subtle_effects.tickers.MobSkullShaderTicker;
import einstein.subtle_effects.tickers.SlimeTrailTicker;
import einstein.subtle_effects.tickers.StomachGrowlingTicker;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.tickers.WitchPotionRingTicker;
import einstein.subtle_effects.tickers.sleeping.BatSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.CatSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.FoxSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.PlayerSleepingTicker;
import einstein.subtle_effects.tickers.sleeping.SleepingTicker;
import einstein.subtle_effects.tickers.sleeping.VillagerSleepingTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ModTickers {
    private static final Predicate<Entity> LOCAL_PLAYER = entity -> entity.equals((Object)Minecraft.getInstance().player);

    public static void init() {
        TickerManager.registerTicker(entity -> true, EntityWaterCauldronTicker::new);
        TickerManager.registerTicker(entity -> !(entity instanceof LightningBolt), EntityFireTicker::new);
        TickerManager.registerTicker(entity -> entity instanceof LivingEntity, ModTickers::getSleepingTicker);
        TickerManager.registerTicker(entity -> entity instanceof AbstractMinecart && ModConfigs.ENTITIES.minecartSparksDisplayType != ModEntityConfigs.MinecartSparksDisplayType.OFF, MinecartSparksTicker::new);
        TickerManager.registerTicker(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.stomachGrowlingThreshold.get() > 0), StomachGrowlingTicker::new);
        TickerManager.registerTicker(LOCAL_PLAYER.and(entity -> ModConfigs.GENERAL.mobSkullShaders), MobSkullShaderTicker::new);
        TickerManager.registerTicker(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.heartBeatingThreshold.get() > 0), HeartbeatTicker::new);
        TickerManager.registerTicker(entity -> ModTickers.isHumanoid(entity, !entity.level().dimension().equals(Level.NETHER)) && ModConfigs.ENTITIES.humanoids.drowningBubblesDisplayType.isEnabled(), DrowningTicker::new);
        TickerManager.registerTicker(entity -> ModTickers.isHumanoid(entity, !entity.level().dimension().equals(Level.NETHER)) && ModConfigs.ENTITIES.humanoids.frostyBreath.displayType.isEnabled(), FrostyBreathTicker::new);
        TickerManager.registerTicker(entity -> entity.getType().equals(EntityType.SLIME) && ModConfigs.ENTITIES.slimeTrails, entity -> new SlimeTrailTicker<Slime>((Slime)entity, ModParticles.SLIME_TRAIL));
        TickerManager.registerTicker(entity -> entity.getType().equals(EntityType.MAGMA_CUBE) && ModConfigs.ENTITIES.magmaCubeTrails, entity -> new SlimeTrailTicker<MagmaCube>((MagmaCube)entity, ModParticles.MAGMA_CUBE_TRAIL));
        TickerManager.registerTicker(entity -> entity.getType().equals(EntityType.IRON_GOLEM) && ModConfigs.ENTITIES.ironGolemCrackParticles, IronGolemTicker::new);
        TickerManager.registerTicker(entity -> entity instanceof ItemEntity && ModConfigs.ENTITIES.itemRarity.particlesDisplayType != ItemRarityConfigs.DisplayType.OFF, ItemRarityTicker::new);
        TickerManager.registerTicker(entity -> entity instanceof Witch && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), WitchPotionRingTicker::new);
        TickerManager.registerTicker(entity -> ModTickers.isNPC(entity, true) && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), entity -> new HumanoidPotionRingTicker<LivingEntity>((LivingEntity)entity));
        TickerManager.registerSimpleTicker(entity -> entity instanceof Player && ModConfigs.ENTITIES.dustClouds.playerRunning, (entity, level, random) -> {
            if (entity.isInvisible()) {
                return;
            }
            if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.isRainingAt(entity.blockPosition())) {
                return;
            }
            Player player = (Player)entity;
            if (ModConfigs.ENTITIES.dustClouds.playerRunningRequiresSpeed && !player.hasEffect(MobEffects.SPEED)) {
                return;
            }
            if (player.canSpawnSprintParticle() && player.onGround() && !player.isUsingItem() && random.nextBoolean()) {
                level.addParticle((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.getRandomX(1.0), entity.getY() + Math.max(Math.min((double)random.nextFloat(), 0.3), 0.2), entity.getRandomZ(1.0), 0.0, random.nextDouble(), 0.0);
            }
        });
        TickerManager.registerSimpleTicker(entity -> entity instanceof FallingBlockEntity && ModConfigs.BLOCKS.fallingBlockDust, (entity, level, random) -> {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            if (fallingBlock.fallDistance <= (double)((Integer)ModConfigs.BLOCKS.fallingBlockDustDistance.get()).intValue()) {
                return;
            }
            if (!fallingBlock.onGround() && !fallingBlock.isNoGravity()) {
                BlockState state = fallingBlock.getBlockState();
                if (((List)ModConfigs.BLOCKS.fallingBlockDustBlocks.get()).contains(state.getBlock())) {
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), entity.getRandomX(1.0), entity.getY() + 0.05, entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.SNOWBALL, () -> (Double)ModConfigs.ENTITIES.snowballTrailDensity.get() > 0.0, (entity, level, random) -> {
            if (ModTickers.shouldSpawn(random, ModConfigs.ENTITIES.snowballTrailDensity)) {
                Vec3 deltaMovement = entity.getDeltaMovement();
                level.addParticle((ParticleOptions)ModParticles.SNOWBALL_TRAIL.get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), deltaMovement.x * 0.5, deltaMovement.y, deltaMovement.z * 0.5);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.ENDER_PEARL, () -> ModConfigs.ENTITIES.enderPearlTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, entity.getRandomX(2.0), entity.getRandomY(), entity.getRandomZ(2.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.ALLAY, () -> (Double)ModConfigs.ENTITIES.allayMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModTickers.shouldSpawn(random, ModConfigs.ENTITIES.allayMagicDensity)) {
                level.addParticle((ParticleOptions)ModParticles.ALLAY_MAGIC.get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        TickerManager.registerSimpleTicker(EntityType.VEX, () -> (Double)ModConfigs.ENTITIES.vexMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModTickers.shouldSpawn(random, ModConfigs.ENTITIES.vexMagicDensity)) {
                level.addParticle((ParticleOptions)new BooleanParticleOptions(ModParticles.VEX_MAGIC.get(), entity.isCharging()), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        TickerManager.registerSimpleTicker(EntityType.CAMEL, () -> ModConfigs.ENTITIES.dustClouds.mobRunning, (entity, level, random) -> {
            if (entity.isDashing() && entity.onGround()) {
                for (int i = 0; i < 10; ++i) {
                    ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig((LivingEntity)entity, level, random, 5);
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.DRAGON_FIREBALL, () -> ModConfigs.ENTITIES.improvedDragonFireballTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, entity.getRandomX(2.0), entity.getRandomY(), entity.getRandomZ(2.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.COMMAND_BLOCK_MINECART, () -> ModConfigs.ENTITIES.commandBlockMinecartParticles != CommandBlockSpawnType.OFF, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.commandBlockMinecartParticles.canTick() && random.nextInt(10) == 0) {
                ParticleSpawnUtil.spawnCmdBlockParticles(level, entity.position().add(0.0, (double)(-(entity.getDisplayOffset() - 8)) / 16.0 + 0.4266666666666667, 0.0), random, (direction, relativePos) -> true);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.TNT, () -> ModConfigs.ENTITIES.explosives.tntSparks, (entity, level, random) -> level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.getRandomX(0.5), entity.getY(1.0), entity.getRandomZ(0.5), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01)));
        TickerManager.registerSimpleTicker(EntityType.TNT, () -> (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get() > 0, (entity, level, random) -> {
            if (random.nextInt(10) == 0) {
                int density = (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get();
                if (density == 1) {
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, entity.getX(), entity.getY(1.1), entity.getZ(), 0.0, 0.0, 0.0);
                    return;
                }
                for (int i = 0; i < density; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.7), entity.getRandomY(), entity.getRandomZ(0.7), 0.0, 0.0, 0.0);
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.END_CRYSTAL, () -> ModConfigs.ENTITIES.endCrystalParticles, (entity, level, random) -> {
            if (level.getBlockState(entity.blockPosition()).getBlock() instanceof BaseFireBlock || random.nextInt(3) == 0) {
                level.addParticle((ParticleOptions)ModParticles.END_CRYSTAL.get(), entity.getRandomX(1.0), entity.getRandomY() + MathUtil.nextNonAbsDouble(random), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.SPECTRAL_ARROW, () -> ModConfigs.ENTITIES.spectralArrowParticles, (entity, level, random) -> {
            if (random.nextInt(3) == 0) {
                level.addParticle((ParticleOptions)Util.GLOWSTONE_DUST_PARTICLES, entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        });
        TickerManager.registerSimpleTicker(EntityType.CREEPER, () -> ModConfigs.ENTITIES.explosives.creeperSparks, (entity, level, random) -> {
            if (entity.isIgnited()) {
                for (int i = 0; i < 3; ++i) {
                    level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                }
            }
        });
        TickerManager.registerSimpleTicker(EntityType.CREEPER, () -> ModConfigs.ENTITIES.explosives.creeperSmoke.isEnabled(), (entity, level, random) -> {
            if (entity.isIgnited()) {
                level.addParticle(ModConfigs.ENTITIES.explosives.creeperSmoke.getParticle().get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
            }
        });
        TickerManager.registerSimpleTicker(entity -> entity instanceof LivingEntity && entity.canFreeze() && ModConfigs.ENTITIES.freezingSnowFlakes, (entity, level, random) -> {
            if (entity.isFreezing() || entity.getTicksFrozen() > 0) {
                level.addParticle((ParticleOptions)ModParticles.FREEZING.get(), entity.getRandomX(1.0), entity.getRandomY(), entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        });
    }

    public static boolean shouldSpawn(RandomSource random, ValidatedDouble chanceConfig) {
        return (double)Math.min(random.nextFloat(), 1.0f) < (Double)chanceConfig.get();
    }

    private static SleepingTicker<?> getSleepingTicker(LivingEntity entity) {
        LivingEntity livingEntity = entity;
        Objects.requireNonNull(livingEntity);
        LivingEntity livingEntity2 = livingEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractVillager.class, Player.class, Bat.class, Cat.class, Fox.class}, (Object)livingEntity2, n)) {
            case 0 -> {
                AbstractVillager villager = (AbstractVillager)livingEntity2;
                yield new VillagerSleepingTicker(villager);
            }
            case 1 -> {
                Player player = (Player)livingEntity2;
                yield new PlayerSleepingTicker(player);
            }
            case 2 -> {
                Bat bat = (Bat)livingEntity2;
                yield new BatSleepingTicker(bat);
            }
            case 3 -> {
                Cat cat = (Cat)livingEntity2;
                yield new CatSleepingTicker(cat);
            }
            case 4 -> {
                Fox fox = (Fox)livingEntity2;
                yield new FoxSleepingTicker(fox);
            }
            default -> new SleepingTicker(entity);
        };
    }

    private static boolean isHumanoid(Entity entity, boolean includePiglins) {
        return entity instanceof Player || ModTickers.isNPC(entity, includePiglins) || entity instanceof Witch;
    }

    private static boolean isNPC(Entity entity, boolean includePiglins) {
        return entity instanceof AbstractVillager || entity instanceof AbstractIllager || includePiglins && entity instanceof AbstractPiglin;
    }
}

