/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import einstein.subtle_effects.configs.blocks.SparksConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LavaFluid.class})
public abstract class LavaFluidMixin {
    @Shadow
    public abstract boolean isSame(Fluid var1);

    @Inject(method={"animateTick"}, at={@At(value="TAIL")})
    private void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random, CallbackInfo ci) {
        SparksConfigs.LavaSparksSpawnType type = ModConfigs.BLOCKS.sparks.lavaSparks;
        if (type.equals((Object)SparksConfigs.LavaSparksSpawnType.OFF) || type.equals((Object)SparksConfigs.LavaSparksSpawnType.NOT_NETHER) && level.dimension().equals(Level.NETHER)) {
            return;
        }
        if (((Boolean)state.getValue((Property)LavaFluid.FALLING)).booleanValue()) {
            for (Direction direction : Direction.values()) {
                BlockPos relativePos = pos.relative(direction);
                if (direction.getAxis() == Direction.Axis.Y || Util.isSolidOrNotEmpty(level, relativePos)) continue;
                ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random), -0.0625f, direction.getOpposite(), level, relativePos, random, MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.07), MathUtil.nextNonAbsDouble(random, 0.1));
            }
            return;
        }
        int count = 1;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos relativePos = pos.offset(x, 0, z);
                if (!this.isSame(level.getFluidState(relativePos).getType()) || level.getBlockState(relativePos).isSolidRender()) {
                    count = 5;
                    continue;
                }
                BlockPos abovePos = relativePos.above();
                if (!Util.isSolidOrNotEmpty(level, abovePos)) continue;
                if (abovePos.equals((Object)pos.above())) {
                    return;
                }
                count = 5;
            }
        }
        for (int i = 0; i < count; ++i) {
            level.addParticle((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random), (double)pos.getX() + 0.5 + random.nextDouble() / 2.0 * (double)MathUtil.nextSign(random), (double)pos.getY() + 0.75 + random.nextDouble() * (double)random.nextInt(3), (double)pos.getZ() + 0.5 + random.nextDouble() / 2.0 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.07), MathUtil.nextNonAbsDouble(random, 0.1));
        }
    }
}

