/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelEventHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelEventHandler.class})
public class LevelEventHandlerMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"levelEvent"}, at={@At(value="TAIL")})
    private void levelEvent(int type, BlockPos pos, int data, CallbackInfo ci) {
        if (this.level == null) {
            return;
        }
        RandomSource random = this.level.getRandom();
        BlockState state = this.level.getBlockState(pos);
        LocalPlayer player = this.minecraft.player;
        switch (type) {
            case 1029: {
                if (!ModConfigs.BLOCKS.anvilBreakParticles) break;
                this.level.addDestroyBlockEffect(pos, Blocks.ANVIL.defaultBlockState());
                break;
            }
            case 1030: {
                if (!ModConfigs.BLOCKS.anvilUseParticles) break;
                float pointX = random.nextFloat();
                float pointZ = random.nextFloat();
                for (int i = 0; i < 20; ++i) {
                    int xSign = MathUtil.nextSign(random);
                    int zSign = MathUtil.nextSign(random);
                    this.level.addParticle((ParticleOptions)SparkParticle.create(SparkType.METAL, random), (double)((float)pos.getX() + pointX), (double)(pos.getY() + 1), (double)((float)pos.getZ() + pointZ), (double)(Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * (float)xSign), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)(Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * (float)zSign));
                }
                break;
            }
            case 1042: {
                if (!ModConfigs.BLOCKS.grindstoneUseParticles) break;
                Direction direction = (Direction)state.getValue((Property)GrindstoneBlock.FACING);
                AttachFace face = (AttachFace)state.getValue((Property)GrindstoneBlock.FACE);
                Direction side = face == AttachFace.CEILING ? Direction.DOWN : Direction.UP;
                for (int i = 0; i < 20; ++i) {
                    ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)SparkParticle.create(SparkType.METAL, random), 0.0f, side, this.level, pos, random, (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepX() * 1.5), face == AttachFace.CEILING ? 0.0 : (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f), (double)Mth.nextFloat((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.getStepZ() * 1.5));
                }
                break;
            }
        }
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;LARGE_SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceSmoke(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.lavaFizzSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;CLOUD:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceCloud(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.spongeDryingOutSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }
}

