/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.block;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ComposterBlock.class})
public class ComposterBlockMixin {
    @Inject(method={"handleFill"}, at={@At(value="TAIL")})
    private static void handleFill(Level level, BlockPos pos, boolean success, CallbackInfo ci) {
        if (ModConfigs.BLOCKS.compostingParticles) {
            RandomSource random = level.getRandom();
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof ComposterBlock) {
                for (int i = 0; i < 10; ++i) {
                    level.addParticle((ParticleOptions)ModParticles.COMPOST.get(), (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), (double)pos.getY() + 0.1875 + 0.125 * (double)((Integer)state.getValue((Property)ComposterBlock.LEVEL)).intValue(), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

