/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.util.Util;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DripParticle.class})
public abstract class DripParticleMixin
extends TextureSheetParticle {
    @Shadow
    protected boolean isGlowing;
    @Shadow
    @Final
    private Fluid type;
    @Unique
    private boolean subtleEffects$dripSoundPlayed;

    protected DripParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ClientLevel level, double x, double y, double z, Fluid fluid, CallbackInfo ci) {
        if (ModConfigs.GENERAL.glowingLavaDrops && fluid.is(FluidTags.LAVA)) {
            this.isGlowing = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/material/Fluids;EMPTY:Lnet/minecraft/world/level/material/Fluid;")})
    private void tick(CallbackInfo ci) {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        BlockState state = this.level.getBlockState(pos);
        FluidState fluidState = this.level.getFluidState(pos);
        double fluidHeight = Math.max(Util.getCauldronFillHeight(state), (double)fluidState.getHeight((BlockGetter)this.level, pos));
        if (fluidHeight > 0.0 && this.y <= (double)pos.getY() + fluidHeight) {
            Fluid fluid = fluidState.isEmpty() ? Util.getCauldronFluid(state) : fluidState.getType();
            boolean isLava = this.type.is(FluidTags.LAVA);
            if (ModConfigs.GENERAL.fluidDropsEvaporate && (fluid.is(FluidTags.LAVA) && !isLava || fluid.is(FluidTags.WATER) && isLava)) {
                this.level.addParticle((ParticleOptions)ModParticles.STEAM.get(), this.x, this.y + 0.1, this.z, 0.0, 0.0, 0.0);
                if (((Float)ModConfigs.GENERAL.fluidDropsEvaporationVolume.get()).floatValue() > 0.0f) {
                    this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, ((Float)ModConfigs.GENERAL.fluidDropsEvaporationVolume.get()).floatValue(), 2.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.8f, false);
                }
                this.remove();
                return;
            }
            if (ModConfigs.GENERAL.dropLandSounds && !this.subtleEffects$dripSoundPlayed) {
                Supplier<SoundEvent> sound = isLava ? ModSounds.DRIP_LAVA_INTO_FLUID : ModSounds.DRIP_WATER_INTO_FLUID;
                this.level.playLocalSound(this.x, this.y, this.z, sound.get(), SoundSource.BLOCKS, Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f), 1.0f, false);
                this.subtleEffects$dripSoundPlayed = true;
            }
        }
    }
}

