/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.SoulFiredCompat;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;

public class EntityFireTicker
extends Ticker<Entity> {
    private final float bbWidth;
    private final float bbHeight;

    public EntityFireTicker(Entity entity) {
        super(entity);
        this.bbWidth = entity.getBbWidth();
        this.bbHeight = entity.getBbHeight();
    }

    @Override
    public void tick() {
        if (this.entity.displayFireAnimation()) {
            if (this.random.nextInt(90) == 0 && ModConfigs.ENTITIES.burning.sounds) {
                Util.playClientSound(this.entity, SoundEvents.FIRE_EXTINGUISH, this.entity.getSoundSource(), 0.3f, 1.0f);
            }
            if (this.bbWidth <= 4.0f && this.bbHeight <= 4.0f) {
                if (ModConfigs.ENTITIES.burning.smoke.isEnabled()) {
                    this.level.addParticle(ModConfigs.ENTITIES.burning.smoke.getParticle().get(), this.entity.getRandomX(1.0), this.entity.getRandomY(), this.entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                if (ModConfigs.ENTITIES.burning.sparks) {
                    for (int i = 0; i < 2; ++i) {
                        this.level.addParticle(this.getParticleForFireType((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, this.random), (ParticleOptions)SparkParticle.createSoul(SparkType.SHORT_LIFE, this.random)), this.entity.getRandomX(1.0), this.entity.getRandomY(), this.entity.getRandomZ(1.0), MathUtil.nextNonAbsDouble(this.random, 0.03), MathUtil.nextNonAbsDouble(this.random, 0.05), MathUtil.nextNonAbsDouble(this.random, 0.03));
                    }
                }
                if (this.bbWidth < 2.0f && this.bbHeight < 2.0f && !this.random.nextBoolean()) {
                    return;
                }
                if (ModConfigs.ENTITIES.burning.flames) {
                    this.level.addParticle(this.getParticleForFireType((ParticleOptions)ParticleTypes.FLAME, (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME), this.entity.getRandomX(1.0), this.entity.getRandomY(), this.entity.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private ParticleOptions getParticleForFireType(ParticleOptions normal, ParticleOptions soul) {
        return CompatHelper.IS_SOUL_FIRED_LOADED.get() != false && SoulFiredCompat.isOnSoulFire(this.entity) ? soul : normal;
    }
}

