/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.phys.Vec3;

public class MinecartSparksTicker
extends Ticker<AbstractMinecart> {
    private static final Vec3[] WHEEL_POSITIONS = new Vec3[]{new Vec3(-1.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(-1.0, 0.0, -1.0), new Vec3(1.0, 0.0, -1.0)};
    private int derailedTicks;
    private int sparksTimer;
    private int sparksCount;
    private Vec3 deltaMovement;

    public MinecartSparksTicker(AbstractMinecart entity) {
        super(entity);
        this.deltaMovement = entity.getDeltaMovement();
    }

    @Override
    public void tick() {
        Vec3 currentDeltaMovement = ((AbstractMinecart)this.entity).getDeltaMovement();
        if (currentDeltaMovement.x() == 0.0 && currentDeltaMovement.z() == 0.0) {
            return;
        }
        this.deltaMovement = currentDeltaMovement;
        if (ModConfigs.ENTITIES.minecartSparksDisplayType == ModEntityConfigs.MinecartSparksDisplayType.DEFAULT) {
            this.spawnSparks(10);
            return;
        }
        BlockPos pos = ((AbstractMinecart)this.entity).blockPosition();
        BlockPos belowPos = pos.below();
        if (this.level.getBlockState(belowPos).is(BlockTags.RAILS)) {
            pos = belowPos;
        }
        if (BaseRailBlock.isRail((Level)this.level, (BlockPos)pos)) {
            if (this.derailedTicks >= 10) {
                this.sparksTimer = 40;
                this.sparksCount = 20;
            } else if (this.derailedTicks >= 5) {
                this.sparksTimer = 20;
                this.sparksCount = 5;
            }
            this.derailedTicks = 0;
        } else {
            ++this.derailedTicks;
        }
        if (this.sparksTimer > 0) {
            --this.sparksTimer;
            this.spawnSparks(this.sparksCount);
            return;
        }
        this.sparksCount = 0;
    }

    private void spawnSparks(int count) {
        count = (int)((float)count * ((Float)ModConfigs.ENTITIES.minecartSparksDensity.get()).floatValue());
        double wHalf = ((AbstractMinecart)this.entity).getBbWidth() / 2.0f;
        for (Vec3 vec3 : WHEEL_POSITIONS) {
            double xSize = wHalf * vec3.x;
            double zSize = wHalf * vec3.z;
            boolean isXNeg = this.deltaMovement.x() < 0.0;
            boolean isZNeg = this.deltaMovement.z() < 0.0;
            boolean isFrontX = isXNeg == vec3.x < 0.0;
            boolean isFrontZ = isZNeg == vec3.z < 0.0;
            double x = ((AbstractMinecart)this.entity).getX() + (xSize + (this.deltaMovement.x() != 0.0 ? (isFrontX ? -0.03 : 0.3) * (double)(isXNeg ? -1 : 1) : 0.0));
            double z = ((AbstractMinecart)this.entity).getZ() + (zSize + (this.deltaMovement.z() != 0.0 ? (isFrontZ ? -0.03 : 0.3) * (double)(isZNeg ? -1 : 1) : 0.0));
            for (int i = 0; i < count / (isFrontX || isFrontZ ? 2 : 1); ++i) {
                double xSpeed = isFrontX ? 0.0 : (double)Mth.nextFloat((RandomSource)this.random, (float)0.1f, (float)0.2f) * (-this.deltaMovement.x() * 1.5);
                double zSpeed = isFrontZ ? 0.0 : (double)Mth.nextFloat((RandomSource)this.random, (float)0.1f, (float)0.2f) * (-this.deltaMovement.z() * 1.5);
                this.level.addParticle((ParticleOptions)SparkParticle.create(SparkType.METAL, this.random), x + MathUtil.nextNonAbsDouble(this.random, isFrontX ? 0.1 : 0.05), ((AbstractMinecart)this.entity).getY(), z + MathUtil.nextNonAbsDouble(this.random, isFrontZ ? 0.1 : 0.05), xSpeed, xSpeed != 0.0 || zSpeed != 0.0 ? (double)Mth.nextFloat((RandomSource)this.random, (float)0.1f, (float)0.2f) : 0.0, zSpeed);
            }
        }
    }
}

