/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.ticking.FireflyManager;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.SparkProviderManager;
import einstein.subtle_effects.ticking.tickers.ChestBlockEntityTicker;
import einstein.subtle_effects.ticking.tickers.WaterfallTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.util.BlockTickerProvider;
import einstein.subtle_effects.util.Util;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin
extends Level {
    @Shadow
    @Final
    @Mutable
    private static Set<Item> MARKER_PARTICLE_ITEMS;

    protected ClientLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionType, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionType, isClientSide, isDebug, biomeZoomSeed, maxNeighborUpdates);
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void clinit(CallbackInfo ci) {
        if (ModConfigs.ITEMS.structureVoidItemMarker) {
            HashSet<Item> markerItems = new HashSet<Item>(MARKER_PARTICLE_ITEMS);
            markerItems.add(Items.STRUCTURE_VOID);
            MARKER_PARTICLE_ITEMS = Set.copyOf(markerItems);
        }
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")})
    private void entityTick(Entity entity, CallbackInfo ci) {
        EntityTickerManager.createTickersForEntity(entity);
    }

    @Inject(method={"tickPassenger"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;rideTick()V")})
    private void entityRideTick(Entity vehicleEntity, Entity entity, CallbackInfo ci) {
        EntityTickerManager.createTickersForEntity(entity);
    }

    @Inject(method={"doAnimateTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;animateTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V")})
    private void animateTick(int x, int y, int z, int range, RandomSource random, Block markerBlock, BlockPos.MutableBlockPos mutablePos, CallbackInfo ci) {
        BlockPos pos = mutablePos.immutable();
        BlockState state = this.getBlockState(pos);
        Block block = state.getBlock();
        FireflyManager.tick(this, pos, state, random);
        if (!state.isAir()) {
            BlockTickerProvider tickerProvider = ModBlockTickers.REGISTERED.get(block);
            if (tickerProvider != null) {
                tickerProvider.apply(state, this, pos, random);
            }
            GeyserManager.tick(this, state, pos);
            ChestBlockEntityTicker.trySpawn(this, pos);
            FluidState fluidState = this.getFluidState(pos);
            if (!fluidState.isEmpty()) {
                WaterfallTicker.trySpawn(this, fluidState, pos);
            }
            ModBlockTickers.REGISTERED_SPECIAL.forEach((predicate, provider) -> {
                if (predicate.test(state)) {
                    provider.apply(state, this, pos, random);
                }
            });
            SparkProviderManager.tick(this, random, block, state, pos);
        }
    }

    @Inject(method={"doAddParticle"}, at={@At(value="HEAD")}, cancellable=true)
    void cullNotLoaded(ParticleOptions particle, boolean overrideLimiter, boolean alwaysShow, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, CallbackInfo ci) {
        if (ModConfigs.GENERAL.enableParticleCulling && ModConfigs.GENERAL.cullParticlesInUnloadedChunks && !Util.isChunkLoaded(this, x, z)) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"doAddParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;distanceToSqr(DDD)D")})
    double cullNotLoaded(Vec3 vec, double x, double y, double z, Operation<Double> original, @Local ParticleStatus particlestatus) {
        if (particlestatus == ParticleStatus.MINIMAL) {
            return 2048.0;
        }
        int maxDistance = (Integer)ModConfigs.GENERAL.particleRenderDistance.get() * 16;
        Double distance = (Double)original.call(new Object[]{vec, x, y, z});
        return distance > (double)(maxDistance * maxDistance) ? 2048.0 : 1.0;
    }
}

