/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelEventHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelEventHandler.class}, priority=999)
public class LevelEventHandlerMixin {
    @Shadow
    @Final
    private ClientLevel level;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"levelEvent"}, at={@At(value="TAIL")})
    private void levelEvent(int type, BlockPos pos, int data, CallbackInfo ci) {
        if (this.level == null) {
            return;
        }
        RandomSource random = this.level.getRandom();
        BlockState state = this.level.getBlockState(pos);
        LocalPlayer player = this.minecraft.player;
        switch (type) {
            case 1029: {
                if (!ModConfigs.BLOCKS.anvilBreakParticles) break;
                this.level.addDestroyBlockEffect(pos, Blocks.ANVIL.defaultBlockState());
                break;
            }
            case 1030: {
                if (!ModConfigs.BLOCKS.anvilUseParticles) break;
                for (int i = 0; i < 3; ++i) {
                    TickerManager.schedule(8 * i, () -> ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (Level)this.level));
                }
                break;
            }
            case 1042: {
                if (!ModConfigs.BLOCKS.grindstoneUseParticles) break;
                ParticleSpawnUtil.spawnGrindstoneUsedParticles((Level)this.level, pos, state, random);
                break;
            }
            case 1044: {
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (Level)this.level);
                break;
            }
            case 1503: {
                TickerManager.scheduleNext(() -> ParticleSpawnUtil.spawnEnderEyePlacementParticles(pos, random, (Level)this.level, Util.getEyeColorHolder((Level)this.level, pos).toInt()));
            }
        }
    }

    @WrapOperation(method={"levelEvent"}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;EFFECT:Lnet/minecraft/core/particles/ParticleType;"), to=@At(value="FIELD", target="Lnet/minecraft/sounds/SoundEvents;SPLASH_POTION_BREAK:Lnet/minecraft/sounds/SoundEvent;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void replaceSplashPotionParticles(ClientLevel level, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original, @Local(ordinal=0) float red, @Local(ordinal=1) float green, @Local(ordinal=2) float blue) {
        if (ModConfigs.ITEMS.splashPotionClouds && level != null) {
            RandomSource random = level.getRandom();
            if (random.nextInt(5) == 0) {
                double powerModifier = random.nextDouble() * 4.0;
                xSpeed *= powerModifier;
                ySpeed = (ySpeed - 0.1) * powerModifier + 0.1;
                zSpeed *= powerModifier;
                if (random.nextInt(3) == 0) {
                    original.call(new Object[]{level, ColorParticleOption.create(ModParticles.POTION_POOF_CLOUD.get(), (float)red, (float)green, (float)blue), x, y, z, xSpeed, ySpeed, zSpeed});
                }
                original.call(new Object[]{level, particleData, x, y, z, xSpeed, ySpeed, zSpeed});
            }
            return;
        }
        original.call(new Object[]{level, particleData, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ParticleUtils;spawnParticlesOnBlockFaces(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/util/valueproviders/IntProvider;)V")})
    private void cancelOrReplaceCopperParticles(Level level, BlockPos pos, ParticleOptions particle, IntProvider count, Operation<Void> original, @Local(argsOnly=true, ordinal=0) int type, @Local(argsOnly=true, ordinal=1) int data) {
        BlockState state = data > 0 ? Block.stateById((int)data) : level.getBlockState(pos);
        RandomSource random = level.getRandom();
        if (type == 3005) {
            if (ModConfigs.ITEMS.axeScrapeParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
                LevelEventHandlerMixin.subtleEffects$spawnCopperParticles(level, pos, count, state, random);
            }
            return;
        }
        if (type == 3004) {
            if (ModConfigs.ITEMS.axeWaxOffParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
                LevelEventHandlerMixin.subtleEffects$spawnCopperParticles(level, pos, count, state, random);
            }
            return;
        }
        original.call(new Object[]{level, pos, particle, count});
    }

    @Unique
    private static void subtleEffects$spawnCopperParticles(Level level, BlockPos pos, IntProvider count, BlockState state, RandomSource random) {
        ParticleSpawnUtil.spawnParticlesAroundShape((ParticleOptions)ParticleTypes.WAX_OFF, level, pos, state, count.sample(random), () -> new Vec3(MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5)), 0.125f);
    }

    @WrapWithCondition(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private boolean shouldSpawnEndPortalFrameSmoke(ClientLevel level, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Local(argsOnly=true, ordinal=0) int type) {
        if (type == 1503) {
            return ModConfigs.BLOCKS.enderEyePlacedParticlesDisplayType != ModBlockConfigs.EnderEyePlacedParticlesDisplayType.DOTS;
        }
        return true;
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;LARGE_SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceSmoke(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.lavaFizzSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;CLOUD:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceCloud(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.spongeDryingOutSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @Inject(method={"shootParticles"}, at={@At(value="TAIL")})
    private void addBubbles(int data, BlockPos pos, RandomSource random, SimpleParticleType type, CallbackInfo ci, @Local Direction direction) {
        if (!ModConfigs.BLOCKS.dispenseItemBubbles) {
            return;
        }
        FluidState fluidState = this.level.getFluidState(pos.relative(direction));
        if (fluidState.is(FluidTags.WATER)) {
            int stepX = direction.getStepX();
            int stepY = direction.getStepY();
            int stepZ = direction.getStepZ();
            for (int i = 0; i < 10; ++i) {
                double speedModifier = random.nextDouble() * 0.2 + 0.01;
                double x = (double)pos.getX() + (double)stepX * 0.6 + 0.5 + (double)stepX * 0.01 + (random.nextDouble() - 0.5) * (double)stepZ * 0.5;
                double y = (double)pos.getY() + (double)stepY * 0.6 + 0.5 + (double)stepY * 0.01 + (random.nextDouble() - 0.5) * (double)stepY * 0.5;
                double z = (double)pos.getZ() + (double)stepZ * 0.6 + 0.5 + (double)stepZ * 0.01 + (random.nextDouble() - 0.5) * (double)stepX * 0.5;
                double xSpeed = (double)stepX * speedModifier + random.nextGaussian() * 0.01;
                double ySpeed = (double)stepY * speedModifier + random.nextGaussian() * 0.01;
                double zSpeed = (double)stepZ * speedModifier + random.nextGaussian() * 0.01;
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, xSpeed, ySpeed, zSpeed);
            }
        }
    }
}

